/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.conqat.lib.commons.collections.UnmodifiableIterator;
import org.conqat.lib.commons.collections.UnmodifiableSortedSet;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class UnmodifiableSortedSetImpl<E>
implements UnmodifiableSortedSet<E> {
    private static final long serialVersionUID = 1L;
    private final SortedSet<E> sortedSet;

    public UnmodifiableSortedSetImpl(SortedSet<E> sortedSet) {
        this.sortedSet = Collections.unmodifiableSortedSet(sortedSet);
    }

    @Override
    public UnmodifiableSortedSet<E> reversed() {
        return UnmodifiableSortedSet.of(this.sortedSet.reversed());
    }

    @Override
    public @NonNull UnmodifiableSortedSet<E> subSet(E fromElement, E toElement) {
        return UnmodifiableSortedSet.of(this.sortedSet.subSet(fromElement, toElement));
    }

    @Override
    public @NonNull UnmodifiableSortedSet<E> headSet(E toElement) {
        return UnmodifiableSortedSet.of(this.sortedSet.headSet(toElement));
    }

    @Override
    public @NonNull UnmodifiableSortedSet<E> tailSet(E fromElement) {
        return UnmodifiableSortedSet.of(this.sortedSet.tailSet(fromElement));
    }

    @Override
    public @Nullable Comparator<? super E> comparator() {
        return this.sortedSet.comparator();
    }

    @Override
    public E first() {
        return this.sortedSet.first();
    }

    @Override
    public E last() {
        return this.sortedSet.last();
    }

    @Override
    public int size() {
        return this.sortedSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.sortedSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.sortedSet.contains(o);
    }

    @Override
    public Object @NonNull [] toArray() {
        return this.sortedSet.toArray();
    }

    @Override
    public <T> T @NonNull [] toArray(T @NonNull [] a) {
        return this.sortedSet.toArray(a);
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> c) {
        return this.sortedSet.containsAll(c);
    }

    @Override
    public @NonNull UnmodifiableIterator<E> iterator() {
        return UnmodifiableIterator.of(this.sortedSet.iterator());
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.sortedSet.spliterator();
    }

    @Override
    public E getFirst() {
        return this.sortedSet.getFirst();
    }

    @Override
    public E getLast() {
        return this.sortedSet.getLast();
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        return this.sortedSet.toArray(generator);
    }

    @Override
    public Stream<E> stream() {
        return this.sortedSet.stream();
    }

    @Override
    public Stream<E> parallelStream() {
        return this.sortedSet.parallelStream();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.sortedSet.forEach(action);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UnmodifiableSortedSetImpl) {
            UnmodifiableSortedSetImpl that = (UnmodifiableSortedSetImpl)o;
            return this.sortedSet.equals(that.sortedSet);
        }
        return this.sortedSet.equals(o);
    }

    @Override
    public int hashCode() {
        return this.sortedSet.hashCode();
    }

    public String toString() {
        return this.sortedSet.toString();
    }
}

