/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.options;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.conqat.lib.commons.options.OptionException;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.conqat.lib.commons.reflect.TypeConversionException;

class OptionApplicator {
    private final Object handler;
    private final Method method;
    private final boolean greedy;

    OptionApplicator(Object optionHandler, Method method, boolean greedy) {
        if (method.getParameterTypes().length > 1) {
            throw new IllegalArgumentException("Method " + method.getName() + " has more than 1 parameter and thus cannot be used as an option!");
        }
        this.handler = optionHandler;
        this.method = method;
        this.greedy = greedy;
    }

    public boolean requiresParameter() {
        return this.method.getParameterTypes().length > 0;
    }

    public void applyOption() throws OptionException {
        if (this.requiresParameter()) {
            throw new IllegalStateException("This option requires a parameter!");
        }
        try {
            this.method.invoke(this.handler, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unexpectedly could not invoke given method " + String.valueOf(this.method) + "!", e);
        }
        catch (InvocationTargetException e) {
            throw new OptionException(e.getCause());
        }
    }

    public void applyOption(String parameter) throws TypeConversionException, OptionException {
        if (!this.requiresParameter()) {
            throw new IllegalStateException("This option does not require a parameter!");
        }
        Object methodParameter = ReflectionUtils.convertString(parameter, this.method.getParameterTypes()[0]);
        try {
            this.method.invoke(this.handler, methodParameter);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unexpectedly could not invoke given method " + String.valueOf(this.method) + "!", e);
        }
        catch (InvocationTargetException e) {
            throw new OptionException(e.getCause());
        }
    }

    public boolean isGreedy() {
        return this.greedy;
    }
}

