/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.teamfoundation.sourcecontrol.webapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssHttpClientBase;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.AssociatedWorkItem;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.TfvcBranch;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.TfvcBranchRef;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.TfvcChange;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.TfvcChangeset;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.TfvcChangesetRef;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.TfvcChangesetSearchCriteria;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.TfvcChangesetsRequestData;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.TfvcItem;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.TfvcItemRequestData;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.TfvcLabel;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.TfvcLabelRef;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.TfvcLabelRequestData;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.TfvcShelveset;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.TfvcShelvesetRef;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.TfvcShelvesetRequestData;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.TfvcVersionDescriptor;
import com.microsoft.alm.teamfoundation.sourcecontrol.webapi.VersionControlRecursionType;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public abstract class TfvcHttpClientBase
extends VssHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected TfvcHttpClientBase(VssRestClientHandler clientHandler, URI baseUrl) {
        super(clientHandler, baseUrl);
    }

    @Override
    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public TfvcBranch getBranch(String project, String path, Boolean includeParent, Boolean includeChildren) {
        UUID locationId = UUID.fromString("bc1f417e-239d-42e7-85e1-76e80cb2d6eb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotNull("includeParent", includeParent);
        queryParameters.addIfNotNull("includeChildren", includeChildren);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TfvcBranch.class);
    }

    public TfvcBranch getBranch(UUID project, String path, Boolean includeParent, Boolean includeChildren) {
        UUID locationId = UUID.fromString("bc1f417e-239d-42e7-85e1-76e80cb2d6eb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotNull("includeParent", includeParent);
        queryParameters.addIfNotNull("includeChildren", includeChildren);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TfvcBranch.class);
    }

    public TfvcBranch getBranch(String path, Boolean includeParent, Boolean includeChildren) {
        UUID locationId = UUID.fromString("bc1f417e-239d-42e7-85e1-76e80cb2d6eb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotNull("includeParent", includeParent);
        queryParameters.addIfNotNull("includeChildren", includeChildren);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TfvcBranch.class);
    }

    public ArrayList<TfvcBranch> getBranches(String project, Boolean includeParent, Boolean includeChildren, Boolean includeDeleted, Boolean includeLinks) {
        UUID locationId = UUID.fromString("bc1f417e-239d-42e7-85e1-76e80cb2d6eb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeParent", includeParent);
        queryParameters.addIfNotNull("includeChildren", includeChildren);
        queryParameters.addIfNotNull("includeDeleted", includeDeleted);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TfvcBranch>>(){});
    }

    public ArrayList<TfvcBranch> getBranches(UUID project, Boolean includeParent, Boolean includeChildren, Boolean includeDeleted, Boolean includeLinks) {
        UUID locationId = UUID.fromString("bc1f417e-239d-42e7-85e1-76e80cb2d6eb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeParent", includeParent);
        queryParameters.addIfNotNull("includeChildren", includeChildren);
        queryParameters.addIfNotNull("includeDeleted", includeDeleted);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TfvcBranch>>(){});
    }

    public ArrayList<TfvcBranch> getBranches(Boolean includeParent, Boolean includeChildren, Boolean includeDeleted, Boolean includeLinks) {
        UUID locationId = UUID.fromString("bc1f417e-239d-42e7-85e1-76e80cb2d6eb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeParent", includeParent);
        queryParameters.addIfNotNull("includeChildren", includeChildren);
        queryParameters.addIfNotNull("includeDeleted", includeDeleted);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TfvcBranch>>(){});
    }

    public ArrayList<TfvcBranchRef> getBranchRefs(String project, String scopePath, Boolean includeDeleted, Boolean includeLinks) {
        UUID locationId = UUID.fromString("bc1f417e-239d-42e7-85e1-76e80cb2d6eb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("includeDeleted", includeDeleted);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TfvcBranchRef>>(){});
    }

    public ArrayList<TfvcBranchRef> getBranchRefs(UUID project, String scopePath, Boolean includeDeleted, Boolean includeLinks) {
        UUID locationId = UUID.fromString("bc1f417e-239d-42e7-85e1-76e80cb2d6eb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("includeDeleted", includeDeleted);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TfvcBranchRef>>(){});
    }

    public ArrayList<TfvcBranchRef> getBranchRefs(String scopePath, Boolean includeDeleted, Boolean includeLinks) {
        UUID locationId = UUID.fromString("bc1f417e-239d-42e7-85e1-76e80cb2d6eb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("includeDeleted", includeDeleted);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TfvcBranchRef>>(){});
    }

    public ArrayList<TfvcChange> getChangesetChanges(Integer id, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("f32b86f2-15b9-4fe6-81b1-6f8938617ee5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TfvcChange>>(){});
    }

    public TfvcChangesetRef createChangeset(TfvcChangeset changeset) {
        UUID locationId = UUID.fromString("0bc8f0a4-6bfb-42a9-ba84-139da7b99c49");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, changeset, "application/json", "application/json");
        return super.sendRequest(httpRequest, TfvcChangesetRef.class);
    }

    public TfvcChangesetRef createChangeset(TfvcChangeset changeset, String project) {
        UUID locationId = UUID.fromString("0bc8f0a4-6bfb-42a9-ba84-139da7b99c49");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, changeset, "application/json", "application/json");
        return super.sendRequest(httpRequest, TfvcChangesetRef.class);
    }

    public TfvcChangesetRef createChangeset(TfvcChangeset changeset, UUID project) {
        UUID locationId = UUID.fromString("0bc8f0a4-6bfb-42a9-ba84-139da7b99c49");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, changeset, "application/json", "application/json");
        return super.sendRequest(httpRequest, TfvcChangesetRef.class);
    }

    public TfvcChangeset getChangeset(String project, int id, Integer maxChangeCount, Boolean includeDetails, Boolean includeWorkItems, Integer maxCommentLength, Boolean includeSourceRename, Integer skip, Integer top, String orderby, TfvcChangesetSearchCriteria searchCriteria) {
        UUID locationId = UUID.fromString("0bc8f0a4-6bfb-42a9-ba84-139da7b99c49");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("maxChangeCount", maxChangeCount);
        queryParameters.addIfNotNull("includeDetails", includeDetails);
        queryParameters.addIfNotNull("includeWorkItems", includeWorkItems);
        queryParameters.addIfNotNull("maxCommentLength", maxCommentLength);
        queryParameters.addIfNotNull("includeSourceRename", includeSourceRename);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotEmpty("$orderby", orderby);
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TfvcChangeset.class);
    }

    public TfvcChangeset getChangeset(UUID project, int id, Integer maxChangeCount, Boolean includeDetails, Boolean includeWorkItems, Integer maxCommentLength, Boolean includeSourceRename, Integer skip, Integer top, String orderby, TfvcChangesetSearchCriteria searchCriteria) {
        UUID locationId = UUID.fromString("0bc8f0a4-6bfb-42a9-ba84-139da7b99c49");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("maxChangeCount", maxChangeCount);
        queryParameters.addIfNotNull("includeDetails", includeDetails);
        queryParameters.addIfNotNull("includeWorkItems", includeWorkItems);
        queryParameters.addIfNotNull("maxCommentLength", maxCommentLength);
        queryParameters.addIfNotNull("includeSourceRename", includeSourceRename);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotEmpty("$orderby", orderby);
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TfvcChangeset.class);
    }

    public TfvcChangeset getChangeset(int id, Integer maxChangeCount, Boolean includeDetails, Boolean includeWorkItems, Integer maxCommentLength, Boolean includeSourceRename, Integer skip, Integer top, String orderby, TfvcChangesetSearchCriteria searchCriteria) {
        UUID locationId = UUID.fromString("0bc8f0a4-6bfb-42a9-ba84-139da7b99c49");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("maxChangeCount", maxChangeCount);
        queryParameters.addIfNotNull("includeDetails", includeDetails);
        queryParameters.addIfNotNull("includeWorkItems", includeWorkItems);
        queryParameters.addIfNotNull("maxCommentLength", maxCommentLength);
        queryParameters.addIfNotNull("includeSourceRename", includeSourceRename);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotEmpty("$orderby", orderby);
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TfvcChangeset.class);
    }

    public ArrayList<TfvcChangesetRef> getChangesets(String project, Integer maxCommentLength, Integer skip, Integer top, String orderby, TfvcChangesetSearchCriteria searchCriteria) {
        UUID locationId = UUID.fromString("0bc8f0a4-6bfb-42a9-ba84-139da7b99c49");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("maxCommentLength", maxCommentLength);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotEmpty("$orderby", orderby);
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TfvcChangesetRef>>(){});
    }

    public ArrayList<TfvcChangesetRef> getChangesets(UUID project, Integer maxCommentLength, Integer skip, Integer top, String orderby, TfvcChangesetSearchCriteria searchCriteria) {
        UUID locationId = UUID.fromString("0bc8f0a4-6bfb-42a9-ba84-139da7b99c49");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("maxCommentLength", maxCommentLength);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotEmpty("$orderby", orderby);
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TfvcChangesetRef>>(){});
    }

    public ArrayList<TfvcChangesetRef> getChangesets(Integer maxCommentLength, Integer skip, Integer top, String orderby, TfvcChangesetSearchCriteria searchCriteria) {
        UUID locationId = UUID.fromString("0bc8f0a4-6bfb-42a9-ba84-139da7b99c49");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("maxCommentLength", maxCommentLength);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotEmpty("$orderby", orderby);
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TfvcChangesetRef>>(){});
    }

    public ArrayList<TfvcChangesetRef> getBatchedChangesets(TfvcChangesetsRequestData changesetsRequestData) {
        UUID locationId = UUID.fromString("b7e7c173-803c-4fea-9ec8-31ee35c5502a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, changesetsRequestData, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TfvcChangesetRef>>(){});
    }

    public ArrayList<AssociatedWorkItem> getChangesetWorkItems(Integer id) {
        UUID locationId = UUID.fromString("64ae0bea-1d71-47c9-a9e5-fe73f5ea0ff4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<AssociatedWorkItem>>(){});
    }

    public ArrayList<ArrayList<TfvcItem>> getItemsBatch(TfvcItemRequestData itemRequestData) {
        UUID locationId = UUID.fromString("fe6f827b-5f64-480f-b8af-1eca3b80e833");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, itemRequestData, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ArrayList<TfvcItem>>>(){});
    }

    public ArrayList<ArrayList<TfvcItem>> getItemsBatch(TfvcItemRequestData itemRequestData, String project) {
        UUID locationId = UUID.fromString("fe6f827b-5f64-480f-b8af-1eca3b80e833");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, itemRequestData, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ArrayList<TfvcItem>>>(){});
    }

    public ArrayList<ArrayList<TfvcItem>> getItemsBatch(TfvcItemRequestData itemRequestData, UUID project) {
        UUID locationId = UUID.fromString("fe6f827b-5f64-480f-b8af-1eca3b80e833");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, itemRequestData, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ArrayList<TfvcItem>>>(){});
    }

    public InputStream getItemsBatchZip(TfvcItemRequestData itemRequestData) {
        UUID locationId = UUID.fromString("fe6f827b-5f64-480f-b8af-1eca3b80e833");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, itemRequestData, "application/json", "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemsBatchZip(TfvcItemRequestData itemRequestData, String project) {
        UUID locationId = UUID.fromString("fe6f827b-5f64-480f-b8af-1eca3b80e833");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, itemRequestData, "application/json", "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemsBatchZip(TfvcItemRequestData itemRequestData, UUID project) {
        UUID locationId = UUID.fromString("fe6f827b-5f64-480f-b8af-1eca3b80e833");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, itemRequestData, "application/json", "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public TfvcItem getItem(String project, String path, String fileName, Boolean download, String scopePath, VersionControlRecursionType recursionLevel, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TfvcItem.class);
    }

    public TfvcItem getItem(UUID project, String path, String fileName, Boolean download, String scopePath, VersionControlRecursionType recursionLevel, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TfvcItem.class);
    }

    public TfvcItem getItem(String path, String fileName, Boolean download, String scopePath, VersionControlRecursionType recursionLevel, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TfvcItem.class);
    }

    public InputStream getItemContent(String project, String path, String fileName, Boolean download, String scopePath, VersionControlRecursionType recursionLevel, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemContent(UUID project, String path, String fileName, Boolean download, String scopePath, VersionControlRecursionType recursionLevel, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemContent(String path, String fileName, Boolean download, String scopePath, VersionControlRecursionType recursionLevel, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public ArrayList<TfvcItem> getItems(String project, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeLinks, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TfvcItem>>(){});
    }

    public ArrayList<TfvcItem> getItems(UUID project, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeLinks, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TfvcItem>>(){});
    }

    public ArrayList<TfvcItem> getItems(String scopePath, VersionControlRecursionType recursionLevel, Boolean includeLinks, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        queryParameters.addIfNotNull("includeLinks", includeLinks);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TfvcItem>>(){});
    }

    public InputStream getItemText(String project, String path, String fileName, Boolean download, String scopePath, VersionControlRecursionType recursionLevel, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "text/plaint");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemText(UUID project, String path, String fileName, Boolean download, String scopePath, VersionControlRecursionType recursionLevel, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "text/plaint");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemText(String path, String fileName, Boolean download, String scopePath, VersionControlRecursionType recursionLevel, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "text/plaint");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemZip(String project, String path, String fileName, Boolean download, String scopePath, VersionControlRecursionType recursionLevel, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemZip(UUID project, String path, String fileName, Boolean download, String scopePath, VersionControlRecursionType recursionLevel, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getItemZip(String path, String fileName, Boolean download, String scopePath, VersionControlRecursionType recursionLevel, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotNull("download", download);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", recursionLevel);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public ArrayList<TfvcItem> getLabelItems(String labelId, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("06166e34-de17-4b60-8cd1-23182a346fda");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("labelId", labelId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TfvcItem>>(){});
    }

    public TfvcLabel getLabel(String project, String labelId, TfvcLabelRequestData requestData) {
        UUID locationId = UUID.fromString("a5d9bd7f-b661-4d0e-b9be-d9c16affae54");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("labelId", labelId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, requestData);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TfvcLabel.class);
    }

    public TfvcLabel getLabel(UUID project, String labelId, TfvcLabelRequestData requestData) {
        UUID locationId = UUID.fromString("a5d9bd7f-b661-4d0e-b9be-d9c16affae54");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("labelId", labelId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, requestData);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TfvcLabel.class);
    }

    public TfvcLabel getLabel(String labelId, TfvcLabelRequestData requestData) {
        UUID locationId = UUID.fromString("a5d9bd7f-b661-4d0e-b9be-d9c16affae54");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("labelId", labelId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, requestData);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TfvcLabel.class);
    }

    public ArrayList<TfvcLabelRef> getLabels(String project, TfvcLabelRequestData requestData, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("a5d9bd7f-b661-4d0e-b9be-d9c16affae54");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, requestData);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TfvcLabelRef>>(){});
    }

    public ArrayList<TfvcLabelRef> getLabels(UUID project, TfvcLabelRequestData requestData, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("a5d9bd7f-b661-4d0e-b9be-d9c16affae54");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, requestData);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TfvcLabelRef>>(){});
    }

    public ArrayList<TfvcLabelRef> getLabels(TfvcLabelRequestData requestData, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("a5d9bd7f-b661-4d0e-b9be-d9c16affae54");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, requestData);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TfvcLabelRef>>(){});
    }

    public ArrayList<TfvcChange> getShelvesetChanges(String shelvesetId, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("dbaf075b-0445-4c34-9e5b-82292f856522");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("shelvesetId", shelvesetId);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TfvcChange>>(){});
    }

    public TfvcShelveset getShelveset(String shelvesetId, TfvcShelvesetRequestData requestData) {
        UUID locationId = UUID.fromString("e36d44fb-e907-4b0a-b194-f83f1ed32ad3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("shelvesetId", shelvesetId);
        this.addModelAsQueryParams(queryParameters, requestData);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TfvcShelveset.class);
    }

    public ArrayList<TfvcShelvesetRef> getShelvesets(TfvcShelvesetRequestData requestData, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("e36d44fb-e907-4b0a-b194-f83f1ed32ad3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, requestData);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TfvcShelvesetRef>>(){});
    }

    public ArrayList<AssociatedWorkItem> getShelvesetWorkItems(String shelvesetId) {
        UUID locationId = UUID.fromString("a7a0c1c1-373e-425a-b031-a519474d743d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("shelvesetId", shelvesetId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<AssociatedWorkItem>>(){});
    }
}

