/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.visualstudio.services.identity.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssHttpClientBase;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.visualstudio.services.identity.ChangedIdentities;
import com.microsoft.alm.visualstudio.services.identity.CreateScopeInfo;
import com.microsoft.alm.visualstudio.services.identity.FrameworkIdentityInfo;
import com.microsoft.alm.visualstudio.services.identity.Identity;
import com.microsoft.alm.visualstudio.services.identity.IdentityBatchInfo;
import com.microsoft.alm.visualstudio.services.identity.IdentityDescriptor;
import com.microsoft.alm.visualstudio.services.identity.IdentityScope;
import com.microsoft.alm.visualstudio.services.identity.IdentitySelf;
import com.microsoft.alm.visualstudio.services.identity.IdentitySnapshot;
import com.microsoft.alm.visualstudio.services.identity.IdentityUpdateData;
import com.microsoft.alm.visualstudio.services.identity.QueryMembership;
import com.microsoft.alm.visualstudio.services.identity.ReadIdentitiesOptions;
import com.microsoft.alm.visualstudio.services.identity.TenantInfo;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import com.microsoft.alm.visualstudio.services.webapi.VssJsonCollectionWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class IdentityHttpClientBase
extends VssHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected IdentityHttpClientBase(VssRestClientHandler clientHandler, URI baseUrl) {
        super(clientHandler, baseUrl);
    }

    @Override
    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public ArrayList<Identity> createGroups(ObjectNode container) {
        UUID locationId = UUID.fromString("5966283b-4196-4d57-9211-1b68f41ec1c2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, container, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Identity>>(){});
    }

    public void deleteGroup(String groupId) {
        UUID locationId = UUID.fromString("5966283b-4196-4d57-9211-1b68f41ec1c2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("groupId", groupId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public ArrayList<Identity> listGroups(String scopeIds, Boolean recurse, Boolean deleted, String properties) {
        UUID locationId = UUID.fromString("5966283b-4196-4d57-9211-1b68f41ec1c2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopeIds", scopeIds);
        queryParameters.addIfNotNull("recurse", recurse);
        queryParameters.addIfNotNull("deleted", deleted);
        queryParameters.addIfNotEmpty("properties", properties);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Identity>>(){});
    }

    public ChangedIdentities getIdentityChanges(int identitySequenceId, int groupSequenceId, UUID scopeId) {
        UUID locationId = UUID.fromString("28010c54-d0c0-4c89-a5b0-1c9e188b9fb7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("identitySequenceId", String.valueOf(identitySequenceId));
        queryParameters.put("groupSequenceId", String.valueOf(groupSequenceId));
        queryParameters.addIfNotNull("scopeId", scopeId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, ChangedIdentities.class);
    }

    public ArrayList<Identity> readIdentities(String descriptors, String identityIds, String searchFilter, String filterValue, QueryMembership queryMembership, String properties, Boolean includeRestrictedVisibility, ReadIdentitiesOptions options) {
        UUID locationId = UUID.fromString("28010c54-d0c0-4c89-a5b0-1c9e188b9fb7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("descriptors", descriptors);
        queryParameters.addIfNotEmpty("identityIds", identityIds);
        queryParameters.addIfNotEmpty("searchFilter", searchFilter);
        queryParameters.addIfNotEmpty("filterValue", filterValue);
        queryParameters.addIfNotNull("queryMembership", queryMembership);
        queryParameters.addIfNotEmpty("properties", properties);
        queryParameters.addIfNotNull("includeRestrictedVisibility", includeRestrictedVisibility);
        queryParameters.addIfNotNull("options", options);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Identity>>(){});
    }

    public ArrayList<Identity> readIdentitiesByScope(UUID scopeId, QueryMembership queryMembership, String properties) {
        UUID locationId = UUID.fromString("28010c54-d0c0-4c89-a5b0-1c9e188b9fb7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("scopeId", scopeId);
        queryParameters.addIfNotNull("queryMembership", queryMembership);
        queryParameters.addIfNotEmpty("properties", properties);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Identity>>(){});
    }

    public Identity readIdentity(String identityId, QueryMembership queryMembership, String properties) {
        UUID locationId = UUID.fromString("28010c54-d0c0-4c89-a5b0-1c9e188b9fb7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("identityId", identityId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("queryMembership", queryMembership);
        queryParameters.addIfNotEmpty("properties", properties);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, Identity.class);
    }

    public ArrayList<IdentityUpdateData> updateIdentities(VssJsonCollectionWrapper<List<Identity>> identities) {
        UUID locationId = UUID.fromString("28010c54-d0c0-4c89-a5b0-1c9e188b9fb7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, apiVersion, identities, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<IdentityUpdateData>>(){});
    }

    public void updateIdentity(Identity identity, UUID identityId) {
        UUID locationId = UUID.fromString("28010c54-d0c0-4c89-a5b0-1c9e188b9fb7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("identityId", identityId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, identity, "application/json", "application/json");
        super.sendRequest(httpRequest);
    }

    public Identity createIdentity(FrameworkIdentityInfo frameworkIdentityInfo) {
        UUID locationId = UUID.fromString("dd55f0eb-6ea2-4fe4-9ebe-919e7dd1dfb4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, apiVersion, frameworkIdentityInfo, "application/json", "application/json");
        return super.sendRequest(httpRequest, Identity.class);
    }

    public ArrayList<Identity> readIdentityBatch(IdentityBatchInfo batchInfo) {
        UUID locationId = UUID.fromString("299e50df-fe45-4d3a-8b5b-a5836fac74dc");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, batchInfo, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Identity>>(){});
    }

    public IdentitySnapshot getIdentitySnapshot(String scopeId) {
        UUID locationId = UUID.fromString("d56223df-8ccd-45c9-89b4-eddf692400d7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeId", scopeId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, IdentitySnapshot.class);
    }

    public IdentitySelf getSelf() {
        UUID locationId = UUID.fromString("4bb02b5b-c120-4be2-b68e-21f7c50a4b82");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, "application/json");
        return super.sendRequest(httpRequest, IdentitySelf.class);
    }

    public boolean addMember(String containerId, String memberId) {
        UUID locationId = UUID.fromString("8ba35978-138e-41f8-8963-7b1ea2c5f775");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("containerId", containerId);
        routeValues.put("memberId", memberId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, Boolean.TYPE);
    }

    public IdentityDescriptor readMember(String containerId, String memberId, QueryMembership queryMembership) {
        UUID locationId = UUID.fromString("8ba35978-138e-41f8-8963-7b1ea2c5f775");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("containerId", containerId);
        routeValues.put("memberId", memberId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("queryMembership", queryMembership);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, IdentityDescriptor.class);
    }

    public ArrayList<IdentityDescriptor> readMembers(String containerId, QueryMembership queryMembership) {
        UUID locationId = UUID.fromString("8ba35978-138e-41f8-8963-7b1ea2c5f775");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("containerId", containerId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("queryMembership", queryMembership);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<IdentityDescriptor>>(){});
    }

    public boolean removeMember(String containerId, String memberId) {
        UUID locationId = UUID.fromString("8ba35978-138e-41f8-8963-7b1ea2c5f775");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("containerId", containerId);
        routeValues.put("memberId", memberId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, Boolean.TYPE);
    }

    public IdentityDescriptor readMemberOf(String memberId, String containerId, QueryMembership queryMembership) {
        UUID locationId = UUID.fromString("22865b02-9e4a-479e-9e18-e35b8803b8a0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("memberId", memberId);
        routeValues.put("containerId", containerId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("queryMembership", queryMembership);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, IdentityDescriptor.class);
    }

    public ArrayList<IdentityDescriptor> readMembersOf(String memberId, QueryMembership queryMembership) {
        UUID locationId = UUID.fromString("22865b02-9e4a-479e-9e18-e35b8803b8a0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("memberId", memberId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("queryMembership", queryMembership);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<IdentityDescriptor>>(){});
    }

    public IdentityScope createScope(CreateScopeInfo info, UUID scopeId) {
        UUID locationId = UUID.fromString("4e11e2bf-1e79-4eb5-8f34-a6337bd0de38");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeId", scopeId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, info, "application/json", "application/json");
        return super.sendRequest(httpRequest, IdentityScope.class);
    }

    public void deleteScope(UUID scopeId) {
        UUID locationId = UUID.fromString("4e11e2bf-1e79-4eb5-8f34-a6337bd0de38");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeId", scopeId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public IdentityScope getScopeById(UUID scopeId) {
        UUID locationId = UUID.fromString("4e11e2bf-1e79-4eb5-8f34-a6337bd0de38");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeId", scopeId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, IdentityScope.class);
    }

    public IdentityScope getScopeByName(String scopeName) {
        UUID locationId = UUID.fromString("4e11e2bf-1e79-4eb5-8f34-a6337bd0de38");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopeName", scopeName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, IdentityScope.class);
    }

    public void renameScope(IdentityScope renameScope, UUID scopeId) {
        UUID locationId = UUID.fromString("4e11e2bf-1e79-4eb5-8f34-a6337bd0de38");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeId", scopeId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, renameScope, "application/json", "application/json");
        super.sendRequest(httpRequest);
    }

    public TenantInfo getTenant(String tenantId) {
        UUID locationId = UUID.fromString("5f0a1723-2e2c-4c31-8cae-002d01bdd592");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("tenantId", tenantId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TenantInfo.class);
    }
}

