/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.registration;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.registration.ArtifactType;
import com.microsoft.tfs.core.clients.registration.OutboundLinkType;
import com.microsoft.tfs.core.clients.registration.RegistrationData;
import com.microsoft.tfs.core.clients.registration.RegistrationEntry;
import com.microsoft.tfs.core.clients.registration.RegistrationExtendedAttribute;
import com.microsoft.tfs.core.clients.registration.ServerMap;
import com.microsoft.tfs.core.clients.registration.ServiceInterface;
import com.microsoft.tfs.core.persistence.FilesystemPersistenceStore;
import com.microsoft.tfs.core.persistence.PersistenceStore;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import java.net.URI;
import ms.tfs.services.registration._03._RegistrationSoap;

public class RegistrationClient {
    private static final long DEFAULT_REFRESH_INTERVAL_MILLIS = 0x6DDD00L;
    private final TFSTeamProjectCollection connection;
    private final long refreshIntervalMillis;
    private final boolean enableDiskCache;
    private volatile RegistrationData registrationData;
    private final _RegistrationSoap webService;

    public RegistrationClient(TFSTeamProjectCollection connection) {
        this(connection, 0x6DDD00L, true);
    }

    public RegistrationClient(TFSTeamProjectCollection connection, long refreshIntervalMillis, boolean enableDiskCache) {
        Check.notNull(connection, "connection");
        this.connection = connection;
        this.refreshIntervalMillis = refreshIntervalMillis;
        this.enableDiskCache = enableDiskCache;
        this.webService = (_RegistrationSoap)connection.getWebService(_RegistrationSoap.class);
    }

    public RegistrationEntry[] getRegistrationEntries() {
        return this.getRegistrationEntries(false);
    }

    public RegistrationEntry[] getRegistrationEntries(boolean forceRefresh) {
        return this.getRegistrationData(forceRefresh).getRegistrationEntries(true);
    }

    public RegistrationEntry getRegistrationEntry(String toolId) {
        return this.getRegistrationEntry(toolId, false);
    }

    public RegistrationEntry getRegistrationEntry(String toolId, boolean forceRefresh) {
        return this.getRegistrationData(forceRefresh).getRegistrationEntry(toolId, true);
    }

    public ServiceInterface[] getServiceInterfaces(String toolId) {
        return this.getServiceInterfaces(toolId, false);
    }

    public ServiceInterface[] getServiceInterfaces(String toolId, boolean forceRefresh) {
        return this.getRegistrationData(forceRefresh).getServiceInterfaces(toolId, true);
    }

    public ServiceInterface getServiceInterface(String toolId, String serviceInterfaceName) {
        return this.getServiceInterface(toolId, serviceInterfaceName, false);
    }

    public ServiceInterface getServiceInterface(String toolId, String serviceInterfaceName, boolean forceRefresh) {
        return this.getRegistrationData(forceRefresh).getServiceInterface(toolId, serviceInterfaceName, true);
    }

    public String getServiceInterfaceURL(String toolId, String serviceInterfaceName) {
        return this.getServiceInterfaceURL(toolId, serviceInterfaceName, false, false);
    }

    public String getServiceInterfaceURL(String toolId, String serviceInterfaceName, boolean forceRefresh, boolean relative) {
        return this.getRegistrationData(forceRefresh).getServiceInterfaceURL(toolId, serviceInterfaceName, relative);
    }

    public ArtifactType[] getArtifactTypes(String toolId) {
        return this.getArtifactTypes(toolId, false);
    }

    public ArtifactType[] getArtifactTypes(String toolId, boolean forceRefresh) {
        return this.getRegistrationData(forceRefresh).getArtifactTypes(toolId, true);
    }

    public ArtifactType getArtifactType(String toolId, String artifactTypeName) {
        return this.getArtifactType(toolId, artifactTypeName, false);
    }

    public ArtifactType getArtifactType(String toolId, String artifactTypeName, boolean forceRefresh) {
        return this.getRegistrationData(forceRefresh).getArtifactType(toolId, artifactTypeName, true);
    }

    public OutboundLinkType[] getOutboundLinkTypes(String toolId, String artifactTypeName) {
        return this.getOutboundLinkTypes(toolId, artifactTypeName, false);
    }

    public OutboundLinkType[] getOutboundLinkTypes(String toolId, String artifactTypeName, boolean forceRefresh) {
        return this.getRegistrationData(forceRefresh).getOutboundLinkTypes(toolId, artifactTypeName, true);
    }

    public RegistrationExtendedAttribute[] getExtendedAttributes(String toolId) {
        return this.getExtendedAttributes(toolId, false);
    }

    public RegistrationExtendedAttribute[] getExtendedAttributes(String toolId, boolean forceRefresh) {
        return this.getRegistrationData(forceRefresh).getExtendedAttributes(toolId, true);
    }

    public RegistrationExtendedAttribute getExtendedAttribute(String toolId, String attributeName) {
        return this.getExtendedAttribute(toolId, attributeName, false);
    }

    public RegistrationExtendedAttribute getExtendedAttribute(String toolId, String attributeName, boolean forceRefresh) {
        return this.getRegistrationData(forceRefresh).getExtendedAttribute(toolId, attributeName, true);
    }

    public String getExtendedAttributeValue(String toolId, String attributeName) {
        return this.getExtendedAttributeValue(toolId, attributeName, false);
    }

    public String getExtendedAttributeValue(String toolId, String attributeName, boolean forceRefresh) {
        return this.getRegistrationData(forceRefresh).getExtendedAttributeValue(toolId, attributeName);
    }

    public GUID getInstanceID() {
        return this.getInstanceID(false);
    }

    public GUID getInstanceID(boolean forceRefresh) {
        return this.getRegistrationData(forceRefresh).getInstanceIDExtendedAttributeValue();
    }

    public void refresh(boolean force) {
        this.getRegistrationData(force);
    }

    private RegistrationData getRegistrationData(boolean forceRefresh) {
        FilesystemPersistenceStore cacheStore = this.connection.getPersistenceStoreProvider().getCachePersistenceStore();
        URI serverUri = this.connection.getBaseURI();
        RegistrationData registrationDataRef = this.registrationData;
        if (!forceRefresh) {
            if (registrationDataRef == null && this.enableDiskCache) {
                registrationDataRef = RegistrationData.load((PersistenceStore)cacheStore, serverUri);
            }
            if (registrationDataRef != null && !registrationDataRef.isDataStale(this.refreshIntervalMillis)) {
                return registrationDataRef;
            }
        }
        registrationDataRef = RegistrationData.newFromServer(this.webService, serverUri);
        if (this.enableDiskCache) {
            this.writeDiskCache(cacheStore, serverUri, registrationDataRef);
        }
        this.registrationData = registrationDataRef;
        return registrationDataRef;
    }

    private void writeDiskCache(PersistenceStore store, URI serverUri, RegistrationData registrationData) {
        Check.notNull(store, "store");
        Check.notNull(serverUri, "serverUri");
        GUID instanceId = registrationData.getInstanceIDExtendedAttributeValue();
        if (instanceId == null) {
            return;
        }
        ServerMap serverMap = ServerMap.load(store);
        serverMap.addServerID(serverUri.toString(), instanceId);
        serverMap.save(store);
        String childLocationName = RegistrationData.makeChildLocationName(serverUri, instanceId.getGUIDString());
        registrationData.save(store, childLocationName);
    }

    public String getRosarioURLForTeamProject(String interfaceName, String projectName) {
        Check.notNullOrEmpty(interfaceName, "interfaceName");
        Check.notNullOrEmpty(projectName, "projectName");
        return this.getServiceInterfaceURL("TeamProjects", projectName + ":" + interfaceName);
    }
}

