/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.team;

import com.microsoft.tfs.core.TFSConnection;
import com.microsoft.tfs.core.clients.commonstructure.CommonStructureClient;
import com.microsoft.tfs.core.clients.commonstructure.ProjectProperty;
import com.microsoft.tfs.core.clients.security.FrameworkSecurity;
import com.microsoft.tfs.core.clients.security.SecurityNamespace;
import com.microsoft.tfs.core.clients.security.SecurityService;
import com.microsoft.tfs.core.clients.team.TeamFoundationTeam;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyUtils;
import com.microsoft.tfs.core.clients.webservices.IIdentityManagementService2;
import com.microsoft.tfs.core.clients.webservices.IdentityDescriptor;
import com.microsoft.tfs.core.clients.webservices.IdentityHelper;
import com.microsoft.tfs.core.clients.webservices.IdentityPermissions;
import com.microsoft.tfs.core.clients.webservices.IdentityPropertyScope;
import com.microsoft.tfs.core.clients.webservices.IdentitySearchFactor;
import com.microsoft.tfs.core.clients.webservices.MembershipQuery;
import com.microsoft.tfs.core.clients.webservices.ReadIdentityOptions;
import com.microsoft.tfs.core.clients.webservices.TeamFoundationIdentity;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class TeamService {
    private final TFSConnection connection;

    public TeamService(TFSConnection connection) {
        Check.notNull(connection, "connection");
        this.connection = connection;
    }

    public TeamFoundationTeam createTeam(String projectId, String name, String description, Map<String, Object> properties) {
        IIdentityManagementService2 identitySvc = (IIdentityManagementService2)this.connection.getClient(IIdentityManagementService2.class);
        IdentityDescriptor desc = identitySvc.createApplicationGroup(projectId, name, description);
        TeamFoundationIdentity group = identitySvc.readIdentity(desc, MembershipQuery.NONE, ReadIdentityOptions.NONE);
        group.setProperty(IdentityPropertyScope.LOCAL, "Microsoft.TeamFoundation.Team", true);
        if (properties != null) {
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                group.setProperty(IdentityPropertyScope.LOCAL, property.getKey(), property.getValue());
            }
        }
        identitySvc.updateExtendedProperties(group);
        SecurityService client = (SecurityService)this.connection.getClient(SecurityService.class);
        SecurityNamespace security = client.getSecurityNamespace(FrameworkSecurity.IDENTITIES_NAMESPACE_ID);
        String token = IdentityHelper.createSecurityToken(group);
        security.setPermissions(token, this.connection.getAuthorizedIdentity().getDescriptor(), IdentityPermissions.ALL_PERMISSIONS.toIntFlags(), 0, false);
        return new TeamFoundationTeam(group);
    }

    public TeamFoundationTeam[] queryTeams(String projectId) {
        IIdentityManagementService2 identitySvc = (IIdentityManagementService2)this.connection.getClient(IIdentityManagementService2.class);
        TeamFoundationIdentity[] projGroups = identitySvc.listApplicationGroups(projectId, ReadIdentityOptions.EXTENDED_PROPERTIES, new String[]{"Microsoft.TeamFoundation.Team"}, IdentityPropertyScope.LOCAL);
        ArrayList<TeamFoundationTeam> teams = new ArrayList<TeamFoundationTeam>();
        for (TeamFoundationIdentity projGroup : projGroups) {
            AtomicReference<Object> object = new AtomicReference<Object>();
            if (!projGroup.tryGetProperty("Microsoft.TeamFoundation.Team", object)) continue;
            teams.add(new TeamFoundationTeam(projGroup));
        }
        return teams.toArray(new TeamFoundationTeam[teams.size()]);
    }

    public TeamFoundationTeam[] queryTeams(IdentityDescriptor descriptor) {
        return this.queryTeams(descriptor, new String[]{"Microsoft.TeamFoundation.Team"});
    }

    public TeamFoundationTeam[] queryTeams(IdentityDescriptor descriptor, String[] propertyNameFilters) {
        IIdentityManagementService2 identitySvc = (IIdentityManagementService2)this.connection.getClient(IIdentityManagementService2.class);
        TeamFoundationIdentity user = identitySvc.readIdentity(descriptor, MembershipQuery.EXPANDED, ReadIdentityOptions.NONE, null, IdentityPropertyScope.NONE);
        ArrayList<TeamFoundationTeam> teams = new ArrayList<TeamFoundationTeam>();
        if (user != null) {
            TeamFoundationIdentity[] parentGroups;
            propertyNameFilters = PropertyUtils.mergePropertyFilters(propertyNameFilters, new String[]{"Microsoft.TeamFoundation.Team"});
            for (TeamFoundationIdentity group : parentGroups = identitySvc.readIdentities(user.getMemberOf(), MembershipQuery.NONE, ReadIdentityOptions.EXTENDED_PROPERTIES, propertyNameFilters, IdentityPropertyScope.LOCAL)) {
                AtomicReference<Object> object = new AtomicReference<Object>();
                if (!group.tryGetProperty("Microsoft.TeamFoundation.Team", object)) continue;
                teams.add(new TeamFoundationTeam(group));
            }
        }
        return teams.toArray(new TeamFoundationTeam[teams.size()]);
    }

    private <T> TeamFoundationTeam readTeamInternal(TeamRetriever<T> teamRetriever, T teamDescriptor, String[] propertyNameFilters) {
        propertyNameFilters = PropertyUtils.mergePropertyFilters(propertyNameFilters, new String[]{"Microsoft.TeamFoundation.Team"});
        TeamFoundationIdentity team = teamRetriever.retrieve(teamDescriptor, propertyNameFilters);
        AtomicReference<Object> object = new AtomicReference<Object>();
        if (team == null || !team.isActive() || !team.tryGetProperty("Microsoft.TeamFoundation.Team", object)) {
            return null;
        }
        return new TeamFoundationTeam(team);
    }

    public TeamFoundationTeam readTeam(IdentityDescriptor descriptor, String[] propertyNameFilters) {
        TeamRetriever<IdentityDescriptor> teamRetriever = new TeamRetriever<IdentityDescriptor>(){

            @Override
            public TeamFoundationIdentity retrieve(IdentityDescriptor id, String[] filters) {
                IIdentityManagementService2 identitySvc = (IIdentityManagementService2)TeamService.this.connection.getClient(IIdentityManagementService2.class);
                return identitySvc.readIdentity(id, MembershipQuery.NONE, ReadIdentityOptions.EXTENDED_PROPERTIES, filters, IdentityPropertyScope.LOCAL);
            }
        };
        return this.readTeamInternal(teamRetriever, descriptor, propertyNameFilters);
    }

    public TeamFoundationTeam readTeam(GUID teamId, String[] propertyNameFilters) {
        TeamRetriever<GUID> teamRetriever = new TeamRetriever<GUID>(){

            @Override
            public TeamFoundationIdentity retrieve(GUID id, String[] filters) {
                IIdentityManagementService2 identitySvc = (IIdentityManagementService2)TeamService.this.connection.getClient(IIdentityManagementService2.class);
                return identitySvc.readIdentities(new GUID[]{id}, MembershipQuery.NONE, ReadIdentityOptions.EXTENDED_PROPERTIES, filters, IdentityPropertyScope.LOCAL)[0];
            }
        };
        return this.readTeamInternal(teamRetriever, teamId, propertyNameFilters);
    }

    public TeamFoundationTeam readTeam(final String projectId, String teamName, String[] propertyNameFilters) {
        TeamRetriever<String> teamRetriever = new TeamRetriever<String>(){

            @Override
            public TeamFoundationIdentity retrieve(String id, String[] filters) {
                IIdentityManagementService2 identitySvc = (IIdentityManagementService2)TeamService.this.connection.getClient(IIdentityManagementService2.class);
                String searchFactor = projectId + "\\" + id;
                return identitySvc.readIdentity(IdentitySearchFactor.ACCOUNT_NAME, searchFactor, MembershipQuery.NONE, ReadIdentityOptions.EXTENDED_PROPERTIES, filters, IdentityPropertyScope.LOCAL);
            }
        };
        return this.readTeamInternal(teamRetriever, teamName, propertyNameFilters);
    }

    public GUID getDefaultTeamID(String projectUri) {
        Check.notNull(projectUri, "projectUri");
        CommonStructureClient cssSvc = (CommonStructureClient)this.connection.getClient(CommonStructureClient.class);
        ProjectProperty defaultTeamProp = cssSvc.getProjectProperty(projectUri, "Microsoft.TeamFoundation.Team.Default");
        if (defaultTeamProp != null && defaultTeamProp.getValue() != null && defaultTeamProp.getValue().length() > 0) {
            return new GUID(defaultTeamProp.getValue());
        }
        return GUID.EMPTY;
    }

    public TeamFoundationTeam getDefaultTeam(String projectUri, String[] propertyNameFilters) {
        GUID teamId = this.getDefaultTeamID(projectUri);
        TeamFoundationTeam team = null;
        if (teamId != GUID.EMPTY) {
            team = this.readTeam(teamId, propertyNameFilters);
        }
        return team;
    }

    public void setDefaultTeam(TeamFoundationTeam team) {
        Check.notNull(team, "team");
        this.setDefaultTeamID(team.getProject(), team.getIdentity().getTeamFoundationID());
    }

    public void setDefaultTeamID(String projectUri, GUID teamId) {
        Check.notNull(projectUri, "projectUri");
        CommonStructureClient cssSvc = (CommonStructureClient)this.connection.getClient(CommonStructureClient.class);
        cssSvc.setProjectProperty(projectUri, "Microsoft.TeamFoundation.Team.Default", teamId.getGUIDString());
    }

    public void updateTeam(TeamFoundationTeam team) {
        IIdentityManagementService2 identitySvc = (IIdentityManagementService2)this.connection.getClient(IIdentityManagementService2.class);
        identitySvc.updateExtendedProperties(team.getIdentity());
    }

    private static interface TeamRetriever<T> {
        public TeamFoundationIdentity retrieve(T var1, String[] var2);
    }
}

