/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyConstants;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.FileHelpers;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class PropertyUtils {
    private static final int MAXIMUM_PROPERTY_NAME_SIZE = 800;

    public static void validatePropertyFilters(String[] propertyNameFilters) {
        PropertyUtils.validatePropertyStrings(propertyNameFilters, 800, "propertyNameFilters");
    }

    public static void validatePropertyFilter(String propertyNameFilter) {
        PropertyUtils.validatePropertyString(propertyNameFilter, 800, "propertyNameFilter");
    }

    private static void validatePropertyStrings(String[] strings, int maxSize, String argumentName) {
        Check.notNull(strings, argumentName);
        for (int i = 0; i < strings.length; ++i) {
            PropertyUtils.validatePropertyString(strings[i], maxSize, argumentName + "[" + i + "]");
        }
    }

    private static void validatePropertyString(String string, int maxSize, String argumentName) {
        Check.notNullOrEmpty(string, argumentName);
        if (string.length() > maxSize) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("PropertyUtils.PropertyNameStoredAtLocationExceedsMaximumSizeCharactersFormat"), string, argumentName, maxSize));
        }
        PropertyUtils.checkForInvalidCharacters(string, argumentName);
    }

    public static void checkForInvalidCharacters(String string, String argumentName) throws IllegalArgumentException {
        Check.notNull(string, argumentName);
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isISOControl(string.charAt(i))) continue;
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("PropertyUtils.UnicodeCharacterValueInArgumentIsControlFormat"), string.charAt(i), argumentName));
        }
    }

    public static PropertyValue[] selectDirtyPropertyValues(PropertyValue[] propertyValues) {
        Check.notNull(propertyValues, "propertyValues");
        ArrayList<PropertyValue> dirtyPropertyValues = new ArrayList<PropertyValue>();
        for (int i = 0; i < propertyValues.length; ++i) {
            Check.notNull(propertyValues[i], "propertyValues[" + i + "]");
            PropertyValue propertyValue = propertyValues[i];
            if (!propertyValue.isDirty()) continue;
            dirtyPropertyValues.add(propertyValue);
        }
        return dirtyPropertyValues.toArray(new PropertyValue[dirtyPropertyValues.size()]);
    }

    public static PropertyValue[] clonePropertyValues(PropertyValue[] values) {
        if (values == null) {
            return null;
        }
        PropertyValue[] ret = new PropertyValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            ret[i] = new PropertyValue(values[i].getPropertyName(), values[i].getPropertyValue());
        }
        return ret;
    }

    public static PropertyValue selectMatching(PropertyValue[] values, String itemPropertyFilter) {
        PropertyValue[] matches = PropertyUtils.selectMatching(values, new String[]{itemPropertyFilter});
        if (matches == null || matches.length == 0) {
            return null;
        }
        return matches[0];
    }

    public static PropertyValue[] selectMatching(PropertyValue[] values, String[] itemPropertyFilters) {
        if (values == null || values.length == 0 || itemPropertyFilters == null || itemPropertyFilters.length == 0) {
            return null;
        }
        HashSet<PropertyValue> matches = new HashSet<PropertyValue>();
        block0: for (PropertyValue value : values) {
            for (String filter : itemPropertyFilters) {
                if (filter == null || !FileHelpers.filenameMatches(value.getPropertyName(), filter, true)) continue;
                matches.add(value);
                continue block0;
            }
        }
        return matches.toArray(new PropertyValue[matches.size()]);
    }

    @Deprecated
    public static PropertyValue[] selectUnique(PropertyValue[] values) {
        if (values == null) {
            return values;
        }
        if (values.length == 0) {
            return new PropertyValue[0];
        }
        return PropertyUtils.selectMatching(values, PropertyConstants.QUERY_ALL_PROPERTIES_FILTERS);
    }

    public static PropertyValue[] mergePendingValues(PropertyValue[] existingValues, PropertyValue[] pendingValues) {
        if (existingValues != null && existingValues.length == 0) {
            existingValues = null;
        }
        if (pendingValues != null && pendingValues.length == 0) {
            pendingValues = null;
        }
        if (existingValues != null && pendingValues != null) {
            TreeMap<String, PropertyValue> map = new TreeMap<String, PropertyValue>(String.CASE_INSENSITIVE_ORDER);
            for (PropertyValue e : existingValues) {
                map.put(e.getPropertyName(), e);
            }
            for (PropertyValue p : pendingValues) {
                map.put(p.getPropertyName(), p);
            }
            return map.values().toArray(new PropertyValue[map.size()]);
        }
        if (existingValues != null) {
            return existingValues;
        }
        if (pendingValues != null) {
            return pendingValues;
        }
        return null;
    }

    public static String[] mergePropertyFilters(String[] filters1, String[] filters2) {
        if (filters1 == null && filters2 == null) {
            return null;
        }
        if (filters1 == null) {
            return filters2;
        }
        if (filters2 == null) {
            return filters1;
        }
        if (filters1.length == 0 && filters2.length == 0) {
            return filters1;
        }
        if (filters1.length == 0) {
            return filters2;
        }
        if (filters2.length == 0) {
            return filters1;
        }
        TreeSet<String> newFilters = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        newFilters.addAll(Arrays.asList(filters1));
        newFilters.addAll(Arrays.asList(filters2));
        return newFilters.toArray(new String[newFilters.size()]);
    }

    public static boolean equals(PropertyValue[] values1, PropertyValue[] values2) {
        if (values1 == values2) {
            return true;
        }
        if (values1 == null || values2 == null) {
            return false;
        }
        if (values1.length != values2.length) {
            return false;
        }
        if (values1.length == 0 && values2.length == 0) {
            return true;
        }
        if (values1.length == 1) {
            return Arrays.equals(values1, values2);
        }
        values1 = (PropertyValue[])values1.clone();
        values2 = (PropertyValue[])values2.clone();
        Arrays.sort(values1);
        Arrays.sort(values2);
        return Arrays.equals(values1, values2);
    }
}

