/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.localworkspace;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.jni.filelock.TFSFileLock;
import com.microsoft.tfs.util.Check;

public class LocalMetadataTableLock {
    private final String yieldRequestLockName;
    private final TFSFileLock fileLock;
    private boolean holdsFileLock;
    private final int retryCount;

    public LocalMetadataTableLock(String filename) {
        this(filename, 7, false);
    }

    public LocalMetadataTableLock(String fileName, boolean requestYield) {
        this(fileName, 7, requestYield);
    }

    public LocalMetadataTableLock(String filename, int retryCount, boolean requestYield) {
        Check.notNull(filename, "filename");
        this.yieldRequestLockName = filename + ";yield";
        this.retryCount = retryCount;
        this.fileLock = new TFSFileLock(filename, false);
        this.acquire(requestYield);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquire(boolean requestYield) {
        int retryCount = 0;
        boolean holdsRequestYieldLock = false;
        TFSFileLock requestYieldLock = null;
        try {
            if (this.fileLock.acquire(0)) {
                this.holdsFileLock = true;
            } else if (requestYield && (requestYieldLock = new TFSFileLock(this.yieldRequestLockName, false)).acquire(0)) {
                holdsRequestYieldLock = true;
            }
            while (!this.holdsFileLock && retryCount++ < this.retryCount) {
                if (this.fileLock.acquire(200 * retryCount * retryCount)) {
                    this.holdsFileLock = true;
                    continue;
                }
                if (!requestYield || holdsRequestYieldLock || !requestYieldLock.acquire(0)) continue;
                holdsRequestYieldLock = true;
            }
            if (!this.holdsFileLock) {
                throw new LocalMetadataTableTimeoutException(Messages.getString("LocalMetadataTableLock.LocalMetadataTableMutexTimeout"));
            }
        }
        finally {
            if (null != requestYieldLock) {
                if (holdsRequestYieldLock) {
                    requestYieldLock.release();
                }
                requestYieldLock.close();
            }
        }
    }

    public void close() {
        if (this.fileLock != null) {
            if (this.holdsFileLock) {
                this.fileLock.release();
            }
            this.fileLock.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isYieldRequested() {
        boolean holdsLock = false;
        TFSFileLock requestYieldLock = new TFSFileLock(this.yieldRequestLockName, false);
        try {
            if (requestYieldLock.acquire(0)) {
                holdsLock = true;
            }
            boolean bl = !holdsLock;
            return bl;
        }
        finally {
            if (null != requestYieldLock) {
                if (holdsLock) {
                    requestYieldLock.release();
                }
                requestYieldLock.close();
            }
        }
    }

    public void yield() {
        Check.isTrue(this.holdsFileLock, "holdsFileLock");
        if (null != this.fileLock) {
            if (this.holdsFileLock) {
                this.fileLock.release();
                this.holdsFileLock = false;
            }
            this.acquire(true);
        }
    }

    public class LocalMetadataTableTimeoutException
    extends RuntimeException {
        private static final long serialVersionUID = 2607330749072651597L;

        public LocalMetadataTableTimeoutException(String message) {
            super(message);
        }
    }
}

