/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingSet;
import com.microsoft.tfs.core.util.TFSUser;
import com.microsoft.tfs.core.util.TFSUsernameParseException;
import java.util.Comparator;

public final class PendingSetComparator
implements Comparator<PendingSet> {
    @Override
    public int compare(PendingSet first, PendingSet second) {
        int res = 0;
        if (first.getOwnerName() != null && second.getOwnerName() != null) {
            TFSUser secondOwner;
            TFSUser firstOwner;
            try {
                firstOwner = new TFSUser(first.getOwnerName());
            }
            catch (TFSUsernameParseException e) {
                return -1;
            }
            try {
                secondOwner = new TFSUser(second.getOwnerName());
            }
            catch (TFSUsernameParseException e) {
                return 1;
            }
            res = firstOwner.compareTo(secondOwner);
            if (res != 0) {
                return res;
            }
        } else {
            if (first.getOwnerName() == null && second.getOwnerName() != null) {
                return -1;
            }
            if (first.getOwnerName() != null && second.getOwnerName() == null) {
                return 1;
            }
        }
        if (first.getComputer() != null && second.getComputer() != null) {
            res = first.getComputer().compareToIgnoreCase(second.getComputer());
            if (res != 0) {
                return res;
            }
        } else {
            if (first.getComputer() == null && second.getComputer() != null) {
                return -1;
            }
            if (first.getComputer() != null && second.getComputer() == null) {
                return 1;
            }
        }
        if (first.getName() != null && second.getName() != null) {
            res = first.getComputer().compareToIgnoreCase(second.getComputer());
            if (res != 0) {
                return res;
            }
        } else {
            if (first.getComputer() == null && second.getComputer() != null) {
                return -1;
            }
            if (first.getComputer() != null && second.getComputer() == null) {
                return 1;
            }
        }
        return 0;
    }
}

