/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.commonstructure.ProjectInfo;
import com.microsoft.tfs.core.clients.reporting.ReportUtils;
import com.microsoft.tfs.core.clients.sharepoint.WSSUtils;
import com.microsoft.tfs.core.clients.workitem.WorkItem;
import com.microsoft.tfs.core.clients.workitem.internal.MacroTargetNotConfiguredException;
import com.microsoft.tfs.core.clients.workitem.project.Project;
import com.microsoft.tfs.core.pguidance.ProcessGuidanceURLInfo;
import com.microsoft.tfs.util.Check;

public class MacroHelpers {
    public static final String ParamMacroProcessGuidanceUrl = "@processguidance";
    public static final String ParamMacroPortal = "@portalpage";
    public static final String ParamMacroReportManagerUrl = "@reportmanagerurl";
    public static final String ParamMacroReportServiceSiteUrl = "@reportservicesiteurl";
    static final String[] macros = new String[]{"@processguidance", "@portalpage", "@reportmanagerurl", "@reportservicesiteurl"};

    public static boolean isMacro(String value) {
        Check.notNull(value, "value");
        if (value.startsWith("@")) {
            String valueLower = value.toLowerCase();
            for (int i = 0; i < macros.length; ++i) {
                if (!valueLower.startsWith(macros[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static String resolveURIMacros(WorkItem workItem, String uriWithMacros) {
        String body;
        String title;
        String trimmedUrl = uriWithMacros.trim();
        String witProtocol = "x-mvwit:";
        if (trimmedUrl.startsWith("x-mvwit:")) {
            trimmedUrl = trimmedUrl.substring("x-mvwit:".length());
        }
        Project project = workItem.getType().getProject();
        TFSTeamProjectCollection connection = project.getWorkItemClient().getConnection();
        String compareUrl = trimmedUrl.toLowerCase();
        String macro = null;
        String url = null;
        if (compareUrl.startsWith(ParamMacroReportServiceSiteUrl)) {
            macro = ParamMacroReportManagerUrl;
            url = ReportUtils.getReportServiceURL(connection);
        } else if (compareUrl.startsWith(ParamMacroProcessGuidanceUrl)) {
            macro = ParamMacroProcessGuidanceUrl;
            ProcessGuidanceURLInfo processGuidence = workItem.getType().getProcessGuidanceURL();
            if (processGuidence != null && processGuidence.isValid()) {
                url = processGuidence.getURL();
            }
        } else if (compareUrl.startsWith(ParamMacroPortal)) {
            macro = ParamMacroPortal;
            url = WSSUtils.getWSSURL(connection, new ProjectInfo(project.getName(), project.getURI()));
        } else if (compareUrl.startsWith(ParamMacroReportManagerUrl)) {
            macro = ParamMacroReportManagerUrl;
            url = ReportUtils.getReportManagerURL(connection);
        } else {
            return uriWithMacros;
        }
        if (url != null && url.length() > 0) {
            if (trimmedUrl.length() == macro.length()) {
                return url;
            }
            return url + trimmedUrl.substring(macro.length());
        }
        if (macro.equals(ParamMacroPortal)) {
            title = Messages.getString("MacroHelpers.NoPortalConfgiredTitle");
            body = Messages.getString("MacroHelpers.NoPortalConfiguredBody");
        } else if (macro.equals(ParamMacroProcessGuidanceUrl)) {
            title = Messages.getString("MacroHelpers.NoProcessConfiguredTitle");
            body = Messages.getString("MacroHelpers.NoProcessConfiguredBody");
        } else {
            title = Messages.getString("MacroHelpers.ReportsNotEnabledTitle");
            body = Messages.getString("MacroHelpers.ReportesNotEnabledBody");
        }
        throw new MacroTargetNotConfiguredException(title, body);
    }
}

