/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.rowset;

import com.microsoft.tfs.core.clients.workitem.internal.WorkItemImpl;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.IMetadata;
import com.microsoft.tfs.core.clients.workitem.internal.revision.RevisionFieldImpl;
import com.microsoft.tfs.core.clients.workitem.internal.revision.RevisionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.BaseGetWorkItemRowSetHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class WorkItemTextsRowSetHandler
extends BaseGetWorkItemRowSetHandler {
    private final Map<Integer, Map<Date, String>> data = new HashMap<Integer, Map<Date, String>>();

    public WorkItemTextsRowSetHandler(WorkItemImpl workItem, IMetadata metadataManager) {
        super(workItem, metadataManager);
    }

    @Override
    protected void doHandleRow() {
        Map<Date, String> valuesForField;
        Integer fieldId = new Integer(this.getIntValue("FldID"));
        Date dateAdded = this.getDateValue("AddedDate");
        String value = this.getStringValue("Words");
        if (value != null && value.trim().length() == 0) {
            value = null;
        }
        if ((valuesForField = this.data.get(fieldId)) == null) {
            valuesForField = new HashMap<Date, String>();
            this.data.put(fieldId, valuesForField);
        }
        valuesForField.put(dateAdded, value);
    }

    @Override
    public void handleEndParsing() {
        HashMap<Integer, String> currentValues = new HashMap<Integer, String>();
        Iterator<Integer> fieldIdIt = this.data.keySet().iterator();
        while (fieldIdIt.hasNext()) {
            currentValues.put(fieldIdIt.next(), null);
        }
        ArrayList fieldIds = new ArrayList(currentValues.keySet());
        for (int i = 0; i < this.getWorkItem().getRevisionsInternal().size(); ++i) {
            RevisionImpl revision = this.getWorkItem().getRevisionsInternal().getRevisionInternal(i);
            Date revisionDate = revision.getRevisionDate();
            for (Integer fieldId : fieldIds) {
                Object value = currentValues.get(fieldId);
                RevisionFieldImpl revisionField = revision.getFieldInternal(fieldId);
                revisionField.setOriginalValue(value);
                Map<Date, String> fieldValues = this.data.get(fieldId);
                if (fieldValues.containsKey(revisionDate)) {
                    String newValue = fieldValues.get(revisionDate);
                    revisionField.setNewValue(newValue);
                    currentValues.put(fieldId, newValue);
                    continue;
                }
                if (fieldId == 54) {
                    revisionField.setNewValue(null);
                    currentValues.put(fieldId, null);
                    continue;
                }
                revisionField.setNewValue(value);
            }
        }
        for (Integer fieldId : fieldIds) {
            String value = (String)currentValues.get(fieldId);
            this.getWorkItem().getFieldsInternal().addOriginalFieldValueFromServer(fieldId, value, false);
        }
    }
}

