/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.type;

import com.microsoft.tfs.core.clients.workitem.internal.type.WIDateTypeConverter;
import com.microsoft.tfs.core.clients.workitem.internal.type.WIDoubleTypeConverter;
import com.microsoft.tfs.core.clients.workitem.internal.type.WIGUIDTypeConverter;
import com.microsoft.tfs.core.clients.workitem.internal.type.WIIdentityTypeConverter;
import com.microsoft.tfs.core.clients.workitem.internal.type.WIIntegerTypeConverter;
import com.microsoft.tfs.core.clients.workitem.internal.type.WIStringTypeConverter;
import com.microsoft.tfs.core.clients.workitem.internal.type.WITypeConverter;

public class WITypeConverterFactory {
    private static final WITypeConverter STRING_CONVERTER = new WIStringTypeConverter(true, true);
    private static final WITypeConverter HTML_CONVERTER = new WIStringTypeConverter(true, false);
    private static final WITypeConverter IDENTITY_CONVERTER = new WIIdentityTypeConverter();
    private static final WITypeConverter INT_CONVERTER = new WIIntegerTypeConverter();
    private static final WITypeConverter DOUBLE_CONVERTER = new WIDoubleTypeConverter();
    private static final WITypeConverter DATE_CONVERTER = new WIDateTypeConverter();
    private static final WITypeConverter GUID_CONVERTER = new WIGUIDTypeConverter();

    public static WITypeConverter getTypeConverter(int psType) {
        if (psType <= 240) {
            if (psType <= 48) {
                switch (psType) {
                    case 16: {
                        return STRING_CONVERTER;
                    }
                    case 32: {
                        return INT_CONVERTER;
                    }
                    case 48: {
                        return DATE_CONVERTER;
                    }
                }
                return IDENTITY_CONVERTER;
            }
            switch (psType) {
                case 64: 
                case 160: {
                    return STRING_CONVERTER;
                }
                case 208: {
                    return GUID_CONVERTER;
                }
            }
            if (psType == 240) {
                return DOUBLE_CONVERTER;
            }
            return IDENTITY_CONVERTER;
        }
        if (psType <= 320) {
            switch (psType) {
                case 272: 
                case 320: {
                    return STRING_CONVERTER;
                }
                case 288: {
                    return INT_CONVERTER;
                }
            }
            return IDENTITY_CONVERTER;
        }
        if (psType != 528 && psType != 576 && psType != 784) {
            return IDENTITY_CONVERTER;
        }
        if (psType == 576) {
            return HTML_CONVERTER;
        }
        return STRING_CONVERTER;
    }
}

