/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.wiqlparse;

import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Condition;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.ConditionalOperators;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.DataType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.IExternal;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Node;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeFieldName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeList;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeTableName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Priority;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.SyntaxError;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Tools;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodeCondition
extends NodeList {
    private Condition condition;
    private final Log log = LogFactory.getLog(NodeCondition.class);

    public NodeCondition() {
        super(NodeType.FIELD_CONDITION, 2);
    }

    public NodeCondition(Condition condition, NodeFieldName left, Node right) {
        super(NodeType.FIELD_CONDITION, 2);
        this.condition = condition;
        this.setLeft(left);
        this.setRight(right);
    }

    @Override
    public void bind(IExternal e, NodeTableName tableContext, NodeFieldName fieldContext) {
        this.getLeft().bind(e, tableContext, fieldContext);
        this.getRight().bind(e, tableContext, fieldContext);
        Tools.ensureSyntax(this.getRight().isConst() || this.getRight() instanceof NodeFieldName, SyntaxError.INVALID_RIGHT_EXPRESSION_IN_CONDITION, this.getRight());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)MessageFormat.format("right - {0} left - {1}", this.getRight().getDataType(), this.getLeft().getDataType()));
        }
        if (e != null) {
            Tools.ensureSyntax(this.getRight().canCastTo(this.getLeft().getDataType(), e.getLocale()), SyntaxError.INCOMPATIBLE_CONDITION_PARTS_TYPE, this);
        }
        if (e != null && (this.getCondition() == Condition.CONTAINS || this.getCondition() == Condition.CONTAINS_WORDS)) {
            Tools.ensureSyntax(this.getLeft().getDataType() == DataType.STRING, SyntaxError.CONTAINS_WORKS_FOR_STRINGS_ONLY, this);
        }
        super.bind(e, tableContext, fieldContext);
    }

    @Override
    public Node optimize(IExternal e, NodeTableName tableContext, NodeFieldName fieldContext) {
        this.setLeft((NodeFieldName)this.getLeft().optimize(e, tableContext, fieldContext));
        this.setRight(this.getRight().optimize(e, tableContext, this.getLeft()));
        return super.optimize(e, tableContext, fieldContext);
    }

    @Override
    public void appendTo(StringBuffer b) {
        super.appendChildren(b, " " + ConditionalOperators.getString(this.condition) + " ");
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition c) {
        this.condition = c;
    }

    @Override
    public DataType getDataType() {
        return DataType.BOOL;
    }

    public NodeFieldName getLeft() {
        return (NodeFieldName)this.getItem(0);
    }

    public void setLeft(NodeFieldName left) {
        this.setItem(0, left);
    }

    @Override
    public Priority getPriority() {
        return Priority.CONDITIONAL_OPERATOR;
    }

    public Node getRight() {
        return this.getItem(1);
    }

    public void setRight(Node right) {
        this.setItem(1, right);
    }
}

