/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.query;

import com.microsoft.tfs.core.clients.workitem.query.QueryDocument;
import com.microsoft.tfs.core.memento.Memento;
import com.microsoft.tfs.core.memento.XMLMemento;
import com.microsoft.tfs.core.util.MementoRepository;
import com.microsoft.tfs.util.StringUtil;

public class ResultOptionsColumnWidthPersistence {
    private static final String PERSISTENCE_KEY = "com.microsoft.tfs.client.common.wit.resultcolumnwidths";
    private static final String ROOT_MEMENTO_NAME = "ColumnWidths";
    private static final String KEY_PREFIX = "doc-";

    public static void restore(MementoRepository mementos, QueryDocument queryDocument) {
        String rootMementoName;
        String documentKey = ResultOptionsColumnWidthPersistence.getKeyForQueryDocument(queryDocument);
        if (documentKey == null) {
            return;
        }
        Memento rootMemento = mementos.load(PERSISTENCE_KEY);
        String string = rootMementoName = rootMemento != null ? rootMemento.getName() : null;
        if (rootMemento == null || StringUtil.isNullOrEmpty(rootMementoName) || !rootMementoName.equals(ROOT_MEMENTO_NAME)) {
            return;
        }
        queryDocument.getResultOptions().loadFromMemento(rootMemento.getChild(documentKey));
    }

    public static void persist(MementoRepository mementos, QueryDocument queryDocument) {
        String rootMementoName;
        String documentKey = ResultOptionsColumnWidthPersistence.getKeyForQueryDocument(queryDocument);
        if (documentKey == null) {
            return;
        }
        Memento rootMemento = mementos.load(PERSISTENCE_KEY);
        String string = rootMementoName = rootMemento != null ? rootMemento.getName() : null;
        if (rootMemento == null || StringUtil.isNullOrEmpty(rootMementoName) || !rootMementoName.equals(ROOT_MEMENTO_NAME)) {
            rootMemento = new XMLMemento(ROOT_MEMENTO_NAME);
        } else {
            rootMemento.removeChildren(documentKey);
        }
        queryDocument.getResultOptions().saveToMemento(rootMemento.createChild(documentKey));
        mementos.save(PERSISTENCE_KEY, rootMemento);
    }

    private static String getKeyForQueryDocument(QueryDocument queryDocument) {
        if (queryDocument.getFile() != null) {
            return KEY_PREFIX + queryDocument.getFile().getAbsolutePath().hashCode();
        }
        if (queryDocument.getGUID() != null) {
            return KEY_PREFIX + queryDocument.getGUID();
        }
        return null;
    }
}

