/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.query.qe;

import com.microsoft.tfs.core.clients.workitem.query.qe.DisplayField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DisplayFieldCollection {
    private final List<DisplayField> list = new ArrayList<DisplayField>();
    private final Map<String, DisplayField> fieldNameToDisplayField = new HashMap<String, DisplayField>();

    public DisplayFieldCollection() {
    }

    public DisplayFieldCollection(DisplayFieldCollection dfc) {
        Iterator<DisplayField> it = dfc.iterator();
        while (it.hasNext()) {
            DisplayField displayField = it.next();
            this.add(new DisplayField(displayField.getFieldName(), displayField.getWidth()));
        }
    }

    public boolean contains(String fieldName) {
        return this.fieldNameToDisplayField.containsKey(fieldName);
    }

    public DisplayField get(String fieldName) {
        return this.fieldNameToDisplayField.get(fieldName);
    }

    public DisplayField[] toArray() {
        return this.list.toArray(new DisplayField[this.list.size()]);
    }

    public Iterator<DisplayField> iterator() {
        return this.list.iterator();
    }

    public void add(DisplayField displayField) {
        this.list.add(displayField);
        this.fieldNameToDisplayField.put(displayField.getFieldName(), displayField);
    }

    public void insert(int index, DisplayField item) {
        this.list.add(index, item);
        this.fieldNameToDisplayField.put(item.getFieldName(), item);
    }

    public void remove(DisplayField item) {
        this.list.remove(item);
        this.fieldNameToDisplayField.remove(item.getFieldName());
    }

    public void removeAt(int index) {
        DisplayField displayField = this.list.remove(index);
        this.fieldNameToDisplayField.remove(displayField.getFieldName());
    }

    public int indexOf(DisplayField displayField) {
        return this.list.indexOf(displayField);
    }

    public int getCount() {
        return this.list.size();
    }

    public DisplayField get(int index) {
        return this.list.get(index);
    }

    public void clear() {
        this.list.clear();
        this.fieldNameToDisplayField.clear();
    }
}

