/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.externaltools.validators;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.externaltools.ExternalTool;
import com.microsoft.tfs.core.externaltools.validators.ExternalToolException;
import com.microsoft.tfs.core.externaltools.validators.ExternalToolValidator;
import java.text.MessageFormat;
import java.util.ArrayList;

public abstract class AbstractToolValidator
implements ExternalToolValidator {
    protected AbstractToolValidator() {
    }

    protected abstract String[] getForbiddenSubstitutions();

    protected abstract String[] getRequiredSubstitutions();

    @Override
    public void validate(ExternalTool externalTool) throws ExternalToolException {
        String[] arguments = externalTool.getArguments();
        String[] forbiddenSubstitutions = this.getForbiddenSubstitutions();
        ArrayList<String> foundForbidden = new ArrayList<String>();
        for (int i = 0; i < forbiddenSubstitutions.length; ++i) {
            for (int j = 0; j < arguments.length; ++j) {
                if (arguments[j].indexOf(forbiddenSubstitutions[i]) == -1) continue;
                foundForbidden.add(forbiddenSubstitutions[i]);
            }
        }
        if (foundForbidden.size() > 0) {
            StringBuffer subs = new StringBuffer();
            for (int i = 0; i < foundForbidden.size(); ++i) {
                if (i > 0) {
                    subs.append(", ");
                }
                subs.append(foundForbidden.get(i));
            }
            throw new ExternalToolException(MessageFormat.format(Messages.getString("AbstractToolValidator.FollowingNotAllowedFormat"), subs.toString()));
        }
        String[] required = this.getRequiredSubstitutions();
        ArrayList<String> missingRequired = new ArrayList<String>();
        for (int i = 0; i < required.length; ++i) {
            boolean found = false;
            for (int j = 0; j < arguments.length; ++j) {
                if (arguments[j].indexOf(required[i]) == -1) continue;
                found = true;
            }
            if (found) continue;
            missingRequired.add(required[i]);
        }
        if (missingRequired.size() > 0) {
            StringBuffer subs = new StringBuffer();
            for (int i = 0; i < missingRequired.size(); ++i) {
                if (i > 0) {
                    subs.append(", ");
                }
                subs.append(missingRequired.get(i));
            }
            throw new ExternalToolException(MessageFormat.format(Messages.getString("AbstractToolValidator.FollowingRequiredFormat"), subs.toString()));
        }
    }
}

