/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.httpclient.auth;

import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.DefaultNTCredentials;
import com.microsoft.tfs.core.httpclient.HttpMethod;
import com.microsoft.tfs.core.httpclient.UsernamePasswordCredentials;
import com.microsoft.tfs.core.httpclient.auth.AuthScheme;
import com.microsoft.tfs.core.httpclient.auth.AuthScope;
import com.microsoft.tfs.core.httpclient.auth.AuthenticationException;
import com.microsoft.tfs.core.httpclient.auth.AuthorizationHeaderScheme;
import com.microsoft.tfs.core.httpclient.auth.MalformedChallengeException;
import com.microsoft.tfs.core.httpclient.auth.WindowsUser;
import com.microsoft.tfs.core.httpclient.util.EncodingUtil;
import com.microsoft.tfs.jni.AuthenticationEngine;
import com.microsoft.tfs.jni.NegotiateEngine;
import com.microsoft.tfs.jni.helpers.LocalHost;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NegotiateScheme
extends AuthorizationHeaderScheme
implements AuthScheme {
    private static final Log LOG = LogFactory.getLog(NegotiateScheme.class);
    private static final int STATUS_NONE = 0;
    private static final int STATUS_INITIATED = 1;
    private static final int STATUS_EXCHANGING = 2;
    private static final int STATUS_COMPLETE = 3;
    private static final int STATUS_ERROR = 4;
    private int status = 0;
    private byte[] inputToken = null;
    private NegotiateEngine.NegotiateClient negotiateClient;
    private final String localHostname = LocalHost.getShortName();

    @Override
    public String getSchemeName() {
        return "negotiate";
    }

    public static boolean isSupported() {
        try {
            return NegotiateEngine.getInstance().isAvailable();
        }
        catch (Exception e) {
            LOG.debug((Object)"Negotiate authentication not supported", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean supportsCredentials(Credentials credentials) {
        if (credentials == null) {
            return false;
        }
        return NegotiateScheme.supportsCredentials(credentials.getClass());
    }

    @Override
    public void cleanup() {
        if (this.negotiateClient != null) {
            this.negotiateClient.dispose();
            this.negotiateClient = null;
        }
        this.inputToken = null;
    }

    public static boolean supportsCredentials(Class<?> credentialClass) {
        if (credentialClass == null || !NegotiateScheme.isSupported()) {
            return false;
        }
        if (credentialClass.equals(DefaultNTCredentials.class)) {
            return NegotiateEngine.getInstance().supportsCredentialsDefault();
        }
        if (credentialClass.equals(UsernamePasswordCredentials.class)) {
            return NegotiateEngine.getInstance().supportsCredentialsSpecified();
        }
        return false;
    }

    public static String getDefaultCredentials() {
        if (!NegotiateScheme.isSupported()) {
            return null;
        }
        return NegotiateEngine.getInstance().getCredentialsDefault();
    }

    public String getRealm() {
        return null;
    }

    @Override
    public String getParameter(String name) {
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.status == 3 || this.status == 4;
    }

    @Override
    public boolean isConnectionBased() {
        return true;
    }

    @Override
    public void processChallenge(String challenge) throws MalformedChallengeException {
        if (this.status == 0 && challenge.equals("Negotiate")) {
            this.cleanup();
            this.status = 1;
        } else if (this.status == 2 && challenge.startsWith("Negotiate ")) {
            this.inputToken = Base64.decodeBase64((byte[])EncodingUtil.getAsciiBytes(challenge.substring(10)));
        } else if (challenge.startsWith("Negotiate")) {
            this.status = 4;
        } else {
            throw new MalformedChallengeException("Unknown challenge: " + challenge);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String authenticate(AuthScope authscope, Credentials credentials, HttpMethod method) throws AuthenticationException {
        byte[] token;
        if (authscope == null || credentials == null || method == null) {
            throw new AuthenticationException("Invalid authentication usage");
        }
        if (!this.supportsCredentials(credentials)) {
            throw new AuthenticationException("Credential type unsupported");
        }
        try {
            if (this.status == 1 && this.negotiateClient == null && this.inputToken == null) {
                this.negotiateClient = (NegotiateEngine.NegotiateClient)NegotiateEngine.getInstance().newClient();
                this.negotiateClient.setTarget("http@" + authscope.getHost().toUpperCase());
                if (credentials instanceof DefaultNTCredentials) {
                    this.negotiateClient.setCredentialsDefault();
                } else {
                    if (!(credentials instanceof UsernamePasswordCredentials)) throw new AuthenticationException("Unsupported credential type");
                    WindowsUser user = new WindowsUser(((UsernamePasswordCredentials)credentials).getUsername());
                    this.negotiateClient.setCredentialsSpecified(user.getUsername(), user.getDomain(), ((UsernamePasswordCredentials)credentials).getPassword());
                    this.negotiateClient.setLocalhost(this.localHostname);
                }
            } else if (this.status != 2 || this.negotiateClient == null || this.inputToken == null) {
                LOG.error((Object)("Negotiate authenticate called in invalid state " + this.status));
                this.status = 4;
                throw new AuthenticationException("Negotiate Authentication Routines Used Out of Order");
            }
            token = this.negotiateClient.getToken(this.inputToken);
            if (this.negotiateClient.isComplete()) {
                this.status = 3;
                this.cleanup();
            } else {
                this.status = 2;
            }
        }
        catch (AuthenticationEngine.AuthenticationException e) {
            LOG.error((Object)("Negotiate failure: " + e.getMessage()));
            this.status = 4;
            return null;
        }
        if (token == null || token.length == 0) {
            this.status = 4;
            throw new AuthenticationException("Negotiate Scheme did not provided token");
        }
        String tokenBase64 = EncodingUtil.getAsciiString(Base64.encodeBase64((byte[])token));
        return "Negotiate " + tokenBase64;
    }
}

