/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.ws.runtime.transport;

import com.microsoft.tfs.core.httpclient.HttpClient;
import com.microsoft.tfs.util.Check;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IdleHTTPConnectionCloser
extends Thread {
    private static final Log log = LogFactory.getLog(IdleHTTPConnectionCloser.class);
    private static final Set clientWeakReferences = new HashSet();
    private static final int IDLE_CONNECTION_CLOSE_TIMEOUT_MILLISECONDS = 120000;
    private static final int THREAD_IDLE_CHECK_PERIOD_MILLISECONDS = 10000;

    public IdleHTTPConnectionCloser() {
        this.setDaemon(true);
        super.setName("Idle HTTP Connection Closer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClient(HttpClient client) {
        Check.notNull(client, "client");
        Set set = clientWeakReferences;
        synchronized (set) {
            clientWeakReferences.add(new WeakReference<HttpClient>(client));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                ArrayList<HttpClient> clients = new ArrayList<HttpClient>();
                Set set = clientWeakReferences;
                synchronized (set) {
                    Iterator i = clientWeakReferences.iterator();
                    while (i.hasNext()) {
                        WeakReference reference = (WeakReference)i.next();
                        HttpClient client = (HttpClient)reference.get();
                        if (client == null) {
                            log.debug((Object)"client reference went null, removing");
                            i.remove();
                            continue;
                        }
                        clients.add(client);
                    }
                }
                if (clients.size() == 0) {
                    log.trace((Object)"no active clients");
                } else {
                    for (HttpClient client : clients) {
                        Check.notNull(client, "client");
                        String messageFormat = "closing connections for {0} idle longer than {1} ms";
                        String message = MessageFormat.format("closing connections for {0} idle longer than {1} ms", client.toString(), 120000);
                        log.trace((Object)message);
                        client.getHttpConnectionManager().closeIdleConnections(120000L);
                        client = null;
                    }
                }
                clients = null;
                String messageFormat = "sleeping {0} ms";
                String message = MessageFormat.format("sleeping {0} ms", 10000);
                log.trace((Object)message);
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException e) {
            log.warn((Object)"interrupted; exiting thread", (Throwable)e);
        }
        catch (Throwable t) {
            log.error((Object)"unexpected error", t);
        }
    }
}

