/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni;

import com.microsoft.tfs.jni.AuthenticationEngine;
import com.microsoft.tfs.jni.Negotiate;
import com.microsoft.tfs.jni.internal.negotiate.NativeNegotiate;
import com.microsoft.tfs.jni.internal.negotiate.NegotiateException;
import com.microsoft.tfs.jni.internal.negotiate.UnavailableNegotiate;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NegotiateEngine
implements AuthenticationEngine {
    private static final Log log = LogFactory.getLog(NegotiateEngine.class);
    private static final NegotiateEngine instance = new NegotiateEngine();
    private final Negotiate impl;

    public static NegotiateEngine getInstance() {
        return instance;
    }

    private NegotiateEngine() {
        Negotiate i = null;
        try {
            if (NativeNegotiate.isAvailable()) {
                i = new NativeNegotiate();
            }
        }
        catch (Exception e) {
            log.warn((Object)MessageFormat.format("{0} reported itself available, but failed to load", NativeNegotiate.class.getName()));
        }
        if (i == null) {
            i = new UnavailableNegotiate();
        }
        this.impl = i;
    }

    @Override
    public boolean isAvailable() {
        return NativeNegotiate.isAvailable();
    }

    @Override
    public boolean supportsCredentialsDefault() {
        return this.impl.supportsCredentialsDefault();
    }

    @Override
    public boolean supportsCredentialsSpecified() {
        return this.impl.supportsCredentialsSpecified();
    }

    @Override
    public String getCredentialsDefault() {
        return this.impl.getCredentialsDefault();
    }

    @Override
    public AuthenticationEngine.AuthenticationClient newClient() throws AuthenticationEngine.AuthenticationException {
        return new NegotiateClient();
    }

    public class NegotiateClient
    implements AuthenticationEngine.AuthenticationClient {
        private final Negotiate.NegotiateState state;

        private NegotiateClient() throws NegotiateException {
            this.state = NegotiateEngine.this.impl.initialize();
        }

        @Override
        public void setCredentialsDefault() throws AuthenticationEngine.AuthenticationException {
            NegotiateEngine.this.impl.setCredentialsDefault(this.state);
        }

        @Override
        public void setCredentialsSpecified(String username, String domain, String password) throws AuthenticationEngine.AuthenticationException {
            NegotiateEngine.this.impl.setCredentialsSpecified(this.state, username, domain, password);
        }

        @Override
        public void setTarget(String target) throws AuthenticationEngine.AuthenticationException {
            NegotiateEngine.this.impl.setTarget(this.state, target);
        }

        public void setLocalhost(String localhost) throws AuthenticationEngine.AuthenticationException {
            NegotiateEngine.this.impl.setLocalhost(this.state, localhost);
        }

        @Override
        public byte[] getToken(byte[] inputToken) throws AuthenticationEngine.AuthenticationException {
            return NegotiateEngine.this.impl.getToken(this.state, inputToken);
        }

        @Override
        public boolean isComplete() throws AuthenticationEngine.AuthenticationException {
            return NegotiateEngine.this.impl.isComplete(this.state);
        }

        @Override
        public String getErrorMessage() {
            return NegotiateEngine.this.impl.getErrorMessage(this.state);
        }

        @Override
        public void dispose() {
            try {
                NegotiateEngine.this.impl.dispose(this.state);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

