/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.FileHelpers;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NewlineUtils {
    private static final Log log = LogFactory.getLog(NewlineUtils.class);
    public static final char LINE_FEED = '\n';
    public static final char CARRIAGE_RETURN = '\r';
    public static final char NEXT_LINE = '\u0085';
    public static final char LINE_TABULATION = '\u000b';
    public static final char FORM_FEED = '\f';
    public static final char LINE_SEPARATOR = '\u2028';
    public static final char PARAGRAPH_SEPARATOR = '\u2029';
    public static final String PLATFORM_NEWLINE = System.getProperty("line.separator");
    public static final String REMOVE = "";
    public static final String SPACE = " ";
    private static final int BUFFERED_READER_MARK_READ_AHEAD_CHARACTERS = 1;

    public static void stripNewlines(Reader reader, Writer writer) throws IOException {
        NewlineUtils.replaceNewlines(reader, writer, SPACE, true);
    }

    public static String stripNewlines(String input) {
        return NewlineUtils.replaceNewlines(input, SPACE, true);
    }

    public static void replaceNewlines(Reader reader, Writer writer, String replacement) throws IOException {
        NewlineUtils.replaceNewlines(reader, writer, replacement, true);
    }

    public static String replaceNewlines(String input, String replacement) {
        return NewlineUtils.replaceNewlines(input, replacement, true);
    }

    public static void normalizeToPlatform(Reader reader, Writer writer) throws IOException {
        NewlineUtils.replaceNewlines(reader, writer, PLATFORM_NEWLINE, false);
    }

    public static String normalizeToPlatform(String input) {
        return NewlineUtils.replaceNewlines(input, PLATFORM_NEWLINE, false);
    }

    public static String detectNewlineConvention(Reader reader) {
        if (reader != null) {
            BufferedReader bufferedReader = new BufferedReader(reader);
            try {
                int currentCharacter;
                while ((currentCharacter = bufferedReader.read()) != -1) {
                    if (currentCharacter == 13 && bufferedReader.read() == 10) {
                        return "\r\n";
                    }
                    if (!NewlineUtils.isNewlineCharacter((char)currentCharacter)) continue;
                    return REMOVE + (char)currentCharacter;
                }
            }
            catch (IOException e) {
                log.error((Object)"Error detecting newline convention", (Throwable)e);
            }
        }
        log.debug((Object)"Could not detect any newlines in stream");
        return null;
    }

    public static void replaceNewlines(Reader reader, Writer writer, String replacement, boolean groupNewlines) throws IOException {
        int currentCharacter;
        if (reader == null) {
            return;
        }
        Check.notNull(writer, "output");
        Check.notNull(replacement, "replacement");
        BufferedReader bufferedReader = new BufferedReader(reader);
        boolean inNewlineGroup = false;
        while ((currentCharacter = bufferedReader.read()) != -1) {
            boolean isNewlineCharacter = NewlineUtils.isNewlineCharacter((char)currentCharacter);
            if (currentCharacter == 13) {
                bufferedReader.mark(1);
                int nextCharacter = bufferedReader.read();
                if (nextCharacter == 10) {
                    currentCharacter = nextCharacter;
                } else {
                    bufferedReader.reset();
                }
            }
            if (isNewlineCharacter) {
                if (groupNewlines) {
                    inNewlineGroup = true;
                    continue;
                }
                writer.write(replacement);
                continue;
            }
            if (groupNewlines && inNewlineGroup) {
                writer.write(replacement);
                inNewlineGroup = false;
            }
            writer.write(currentCharacter);
        }
        if (inNewlineGroup) {
            writer.write(replacement);
            inNewlineGroup = false;
        }
    }

    public static String replaceNewlines(String input, String replacement, boolean groupNewlines) {
        if (input == null) {
            return null;
        }
        Check.notNull(replacement, "replacement");
        StringReader inputReader = new StringReader(input);
        StringWriter result = new StringWriter();
        try {
            NewlineUtils.replaceNewlines(inputReader, result, replacement, groupNewlines);
        }
        catch (IOException e) {
            throw new RuntimeException("Error converting newline characters", e);
        }
        return result.toString();
    }

    public static boolean isNewlineCharacter(char c) {
        return c == '\n' || c == '\r' || c == '\u0085' || c == '\u000b' || c == '\f' || c == '\u2028' || c == '\u2029';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertFile(File file, Charset charset, String desiredNewlineSequence) throws UnsupportedEncodingException, IOException {
        Check.notNull(file, "file");
        Check.notNull(desiredNewlineSequence, "desiredNewlineSequence");
        File directory = file.getParentFile();
        File temp = File.createTempFile("tfsEOL", ".tmp", directory);
        try {
            String messageFormat;
            Reader reader = null;
            Writer writer = null;
            try {
                if (charset == null) {
                    reader = new InputStreamReader(new FileInputStream(file));
                    writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(temp)));
                } else {
                    CharsetDecoder decoder = charset.newDecoder();
                    decoder.onMalformedInput(CodingErrorAction.REPORT);
                    decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                    reader = new InputStreamReader((InputStream)new FileInputStream(file), decoder);
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(temp), charset));
                }
                NewlineUtils.replaceNewlines(reader, writer, desiredNewlineSequence, false);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error closing reader", (Throwable)e);
                    }
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error closing writer", (Throwable)e);
                    }
                }
            }
            if (!file.delete()) {
                messageFormat = "Error deleting file '{0}' for replacement with EOL-converted file.";
                String message = MessageFormat.format("Error deleting file '{0}' for replacement with EOL-converted file.", file.getAbsolutePath());
                log.error((Object)message);
                throw new IOException(message);
            }
            if (!FileHelpers.renameWithoutException(temp, file)) {
                messageFormat = "Error renaming temporary file '{0}' to '{1}' after EOL conversion.";
                String message = MessageFormat.format("Error renaming temporary file '{0}' to '{1}' after EOL conversion.", temp.getAbsolutePath(), file.getAbsolutePath());
                log.error((Object)message);
                throw new IOException(message);
            }
            temp = null;
        }
        finally {
            if (temp != null) {
                temp.delete();
            }
        }
    }
}

