/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.valid;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Messages;
import com.microsoft.tfs.util.valid.IValidationMessage;
import com.microsoft.tfs.util.valid.IValidity;
import com.microsoft.tfs.util.valid.Severity;
import com.microsoft.tfs.util.valid.ValidationMessage;
import com.microsoft.tfs.util.valid.Validator;
import com.microsoft.tfs.util.valid.Validity;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;

public class ValidationUtils {
    public static boolean validitysEqual(IValidity v1, IValidity v2) {
        IValidationMessage[] messages2;
        Check.notNull(v1, "v1");
        Check.notNull(v2, "v2");
        if (v1 == v2) {
            return true;
        }
        if (v1.getSeverity() != v2.getSeverity()) {
            return false;
        }
        IValidationMessage[] messages1 = v1.getMessages();
        if (messages1.length != (messages2 = v2.getMessages()).length) {
            return false;
        }
        for (int i = 0; i < messages1.length; ++i) {
            if (messages1[i] == null && messages2[i] == null) continue;
            if (messages1[i] == null && messages2[i] != null || messages1[i] != null && messages2[i] == null) {
                return false;
            }
            if (ValidationUtils.validationMessagesEqual(messages1[i], messages2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean validationMessagesEqual(IValidationMessage m1, IValidationMessage m2) {
        Check.notNull(m1, "m1");
        Check.notNull(m2, "m2");
        if (m1 == m2) {
            return true;
        }
        if (m1.getSeverity() != m2.getSeverity()) {
            return false;
        }
        if (m1.getMessage() == null) {
            return m2.getMessage() == null;
        }
        return m1.getMessage().equals(m2.getMessage());
    }

    public static void throwIfInvalid(Validator validator) {
        String message;
        Check.notNull(validator, "validator");
        IValidity validity = validator.getValidity();
        if (validity.isValid()) {
            return;
        }
        IValidationMessage m = validity.getFirstMessage();
        String className = validator.getClass().getName();
        if (m != null) {
            String messageFormat = Messages.getString("ValidationUtils.ValidationErrorWithMessageFormat");
            message = MessageFormat.format(messageFormat, m.getMessage(), className);
        } else {
            String messageFormat = Messages.getString("ValidationUtils.ValidationErrorNoMessageFormat");
            message = MessageFormat.format(messageFormat, className);
        }
        throw new IllegalArgumentException(message);
    }

    public static IValidity combineValiditys(IValidity[] validitys) {
        Check.notNull(validitys, "validitys");
        if (validitys.length == 0) {
            throw new IllegalArgumentException("validitys length is 0");
        }
        int validitysWithMessagesCount = 0;
        for (int i = 0; i < validitys.length; ++i) {
            if (validitys[i] == null) {
                throw new IllegalArgumentException("validitys " + i + " is null");
            }
            if (validitys[i].getMessages().length <= 0) continue;
            ++validitysWithMessagesCount;
        }
        if (validitysWithMessagesCount == 0) {
            Severity maxSeverity = null;
            for (int i = 0; i < validitys.length; ++i) {
                if (maxSeverity != null && maxSeverity.getPriority() >= validitys[i].getSeverity().getPriority()) continue;
                maxSeverity = validitys[i].getSeverity();
            }
            return new Validity(maxSeverity);
        }
        ArrayList<IValidationMessage> validationMessages = new ArrayList<IValidationMessage>();
        for (int i = 0; i < validitys.length; ++i) {
            IValidationMessage[] currentMessages = validitys[i].getMessages();
            if (currentMessages != null) {
                validationMessages.addAll(Arrays.asList(currentMessages));
                continue;
            }
            ValidationMessage syntheticMessage = new ValidationMessage(validitys[i].getSeverity());
            validationMessages.add(syntheticMessage);
        }
        IValidationMessage[] messagesArray = validationMessages.toArray(new IValidationMessage[validationMessages.size()]);
        return new Validity(messagesArray);
    }
}

