/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.Arrays;
import java.util.Objects;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksObject;

public class ColumnFamilyHandle
extends RocksObject {
    private final RocksDB rocksDB_;

    ColumnFamilyHandle(RocksDB rocksDB, long nativeHandle) {
        super(nativeHandle);
        assert (rocksDB != null);
        this.rocksDB_ = rocksDB;
    }

    ColumnFamilyHandle(long nativeHandle) {
        super(nativeHandle);
        this.rocksDB_ = null;
        this.disOwnNativeHandle();
    }

    public byte[] getName() throws RocksDBException {
        assert (this.isOwningHandle() || this.isDefaultColumnFamily());
        return this.getName(this.nativeHandle_);
    }

    public int getID() {
        assert (this.isOwningHandle() || this.isDefaultColumnFamily());
        return this.getID(this.nativeHandle_);
    }

    public ColumnFamilyDescriptor getDescriptor() throws RocksDBException {
        assert (this.isOwningHandle() || this.isDefaultColumnFamily());
        return this.getDescriptor(this.nativeHandle_);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnFamilyHandle that = (ColumnFamilyHandle)o;
        try {
            return this.rocksDB_.nativeHandle_ == that.rocksDB_.nativeHandle_ && this.getID() == that.getID() && Arrays.equals(this.getName(), that.getName());
        }
        catch (RocksDBException e) {
            throw new RuntimeException("Cannot compare column family handles", e);
        }
    }

    public int hashCode() {
        try {
            int result = Objects.hash(this.getID(), this.rocksDB_.nativeHandle_);
            result = 31 * result + Arrays.hashCode(this.getName());
            return result;
        }
        catch (RocksDBException e) {
            throw new RuntimeException("Cannot calculate hash code of column family handle", e);
        }
    }

    protected boolean isDefaultColumnFamily() {
        return this.nativeHandle_ == this.rocksDB_.getDefaultColumnFamily().nativeHandle_;
    }

    @Override
    protected void disposeInternal() {
        if (this.rocksDB_.isOwningHandle()) {
            this.disposeInternal(this.nativeHandle_);
        }
    }

    private native byte[] getName(long var1) throws RocksDBException;

    private native int getID(long var1);

    private native ColumnFamilyDescriptor getDescriptor(long var1) throws RocksDBException;

    @Override
    protected final native void disposeInternal(long var1);
}

