/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.architecture;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserIndex;
import com.teamscale.index.architecture.ArchitectureAssessmentIndex;
import com.teamscale.index.architecture.ArchitectureAssessmentInfo;
import com.teamscale.index.architecture.ArchitectureAssessmentInfoUtils;
import com.teamscale.index.architecture.ArchitectureComponentInfo;
import com.teamscale.index.architecture.ArchitectureConstraintInfo;
import com.teamscale.index.architecture.ArchitectureEditorUtils;
import com.teamscale.index.architecture.ArchitectureInfo;
import com.teamscale.index.architecture.DependencyPolicyInfo;
import com.teamscale.index.architecture.ITypeToFileLookup;
import com.teamscale.index.architecture.TypeDependencyInfo;
import com.teamscale.index.architecture.assessment.ArchitectureAnnotator;
import com.teamscale.index.architecture.assessment.ArchitectureAssessor;
import com.teamscale.index.architecture.assessment.TypeToComponentMapper;
import com.teamscale.index.architecture.assessment.shared.CodeMapping;
import com.teamscale.index.architecture.commons.EFindingCreationType;
import com.teamscale.index.architecture.external.ArchitectureUploadAnalysisStateIndex;
import com.teamscale.index.architecture.format.ECodeMappingType;
import com.teamscale.index.architecture.incremental.ArchitectureFileDependenciesIndex;
import com.teamscale.index.architecture.incremental.ArchitectureTypeDependenciesIndex;
import com.teamscale.index.architecture.incremental.TypeComponentMapping;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.architecture.scope.ComponentNode;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.dependencies.TypeDependencyIndex;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.findings.calculation.FindingsServiceUtils;
import com.teamscale.index.requirements_tracing.index.SpecItemHistoryIndex;
import com.teamscale.index.requirements_tracing.merge_request.SpecItemMappingToIdsEvaluator;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.service.architecture.ArchitectureAssessmentDto;
import com.teamscale.service.architecture.ArchitectureAssessmentUtils;
import com.teamscale.service.architecture.ArchitectureOverviewInfo;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.wia.TeamscaleIssueId;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.ArchitectureCreationModificationInfo;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/architectures/assessments")
public class ArchitectureAssessmentService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Path(value="{uniformPath}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get architecture assessment", description="Returns the architecture assessment with the identifier in the path parameter. Returns an empty assessment if an unknown identifier is given.", tags={"Architecture"})
    public ArchitectureAssessmentDto getArchitectureAssessment(@Parameter(description="ID of the project where architecture is defined.") @PathParam(value="project") PublicProjectId projectId, @Parameter(description="Uniform path of requested architecture") @PathParam(value="uniformPath") @DefaultValue(value="") UniformPath uniformPath, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        this.checkArchitectureAssessmentIndexExists(projectId);
        HistoryAccessOption historyOption = this.determineHistoryOption(commit);
        ArchitectureAssessmentIndex architectureAssessmentIndex = this.openProjectIndex(ArchitectureAssessmentIndex.class, historyOption);
        TokenElementIndex contentIndex = this.openProjectIndex(TokenElementIndex.class, "content", historyOption);
        ArchitectureAssessmentInfo assessmentInfo = ArchitectureAssessmentUtils.getAssessmentInfo(uniformPath.toString(), architectureAssessmentIndex);
        ArchitectureDefinition architecture = ArchitectureAssessmentUtils.getArchitectureDefinition(uniformPath.toString(), contentIndex);
        return this.buildArchitectureAssessmentDto(architecture, assessmentInfo, historyOption, null);
    }

    private ArchitectureAssessmentDto buildArchitectureAssessmentDto(ArchitectureDefinition architecture, ArchitectureAssessmentInfo assessmentInfo, HistoryAccessOption historyOption, Pattern typeSearchPattern) throws StorageException {
        Map findingsByPath = FindingsServiceUtils.getFindingsVirtualPathAware((ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)historyOption, (UniformPath)UniformPath.codeRoot());
        Map<String, List<TeamscaleIssueId>> matchedSpecItemIds = this.findMatchedSpecItemIds(architecture, historyOption.getBranchName());
        return new ArchitectureAssessmentDto(ArchitectureAssessmentService.buildArchitectureComponentDto(architecture, assessmentInfo.getRoot(), matchedSpecItemIds, typeSearchPattern), assessmentInfo.getOrphans(), ArchitectureAssessmentService.buildDependencyPolicies(architecture, assessmentInfo, findingsByPath), assessmentInfo.fileBased, assessmentInfo.legacyCodeMapping, assessmentInfo.structureOnly, assessmentInfo.findingCreation, (List<ArchitectureConstraintInfo>)assessmentInfo.getConstraints(), (Set<String>)assessmentInfo.getUnsupportedLanguages(), assessmentInfo.getViolationCount(), this.buildCreationModificationDto(architecture.getCreationAndModificationInfo()), architecture.getScopeIncludePattern(), architecture.getScopeExcludePattern());
    }

    private ArchitectureAssessmentDto.ArchitectureCreationModificationDto buildCreationModificationDto(ArchitectureCreationModificationInfo creationModificationInfo) throws StorageException {
        UserIndex userIndex = this.openGlobalIndex(UserIndex.class);
        return new ArchitectureAssessmentDto.ArchitectureCreationModificationDto(this.resolveUser(userIndex, creationModificationInfo.getCreatedBy()), creationModificationInfo.getCreationDate(), this.resolveUser(userIndex, creationModificationInfo.getLastModifiedBy()), creationModificationInfo.getModificationDate());
    }

    private ArchitectureAssessmentDto.ArchitectureCreationModificationDto.ArchitectureUserDto resolveUser(UserIndex userIndex, @Nullable String userName) throws StorageException {
        if (userName == null) {
            return null;
        }
        User resolvedUser = null;
        if (this.getPermissions().hasBasicPermission(EBasicPermissionScope.USERS, userName, EBasicPermission.VIEW)) {
            resolvedUser = userIndex.getUser(userName);
        }
        if (resolvedUser == null) {
            return new ArchitectureAssessmentDto.ArchitectureCreationModificationDto.ArchitectureUserDto(userName, null, null);
        }
        return new ArchitectureAssessmentDto.ArchitectureCreationModificationDto.ArchitectureUserDto(userName, resolvedUser.getFirstName(), resolvedUser.getLastName());
    }

    private static List<ArchitectureAssessmentDto.ArchitectureDependencyPolicyDto> buildDependencyPolicies(ArchitectureDefinition architecture, ArchitectureAssessmentInfo assessmentInfo, Map<UniformPath, List<TrackedFinding>> findingsByPath) {
        ListMap<Pair<String, String>, String> findingIdsByDependency = ArchitectureAssessmentUtils.getViolationFindingsForArchitecture(architecture, findingsByPath);
        ArrayList<ArchitectureAssessmentDto.ArchitectureDependencyPolicyDto> result = new ArrayList<ArchitectureAssessmentDto.ArchitectureDependencyPolicyDto>();
        for (DependencyPolicyInfo policyInfo : assessmentInfo.getPolicies()) {
            List<ArchitectureAssessmentDto.ArchitectureDependencyPolicyDto.ArchitectureTypeDependencyDto> dependencies = ArchitectureAssessmentService.buildTypeDependencies(architecture, (Collection<TypeDependencyInfo>)policyInfo.getDependencies(), findingIdsByDependency);
            List<ArchitectureAssessmentDto.ArchitectureDependencyPolicyDto.ArchitectureTypeDependencyDto> toleratedDependencies = ArchitectureAssessmentService.buildTypeDependencies(architecture, (Collection<TypeDependencyInfo>)policyInfo.getToleratedDependencies(), findingIdsByDependency);
            result.add(new ArchitectureAssessmentDto.ArchitectureDependencyPolicyDto(policyInfo.getFrom(), policyInfo.getTo(), (List<Point>)policyInfo.getPoints(), policyInfo.getPolicyType(), policyInfo.getAssessmentType(), dependencies, toleratedDependencies));
        }
        return result;
    }

    private static List<ArchitectureAssessmentDto.ArchitectureDependencyPolicyDto.ArchitectureTypeDependencyDto> buildTypeDependencies(ArchitectureDefinition architecture, Collection<TypeDependencyInfo> dependencies, ListMap<Pair<String, String>, String> findingIdsByDependency) {
        ArrayList<ArchitectureAssessmentDto.ArchitectureDependencyPolicyDto.ArchitectureTypeDependencyDto> result = new ArrayList<ArchitectureAssessmentDto.ArchitectureDependencyPolicyDto.ArchitectureTypeDependencyDto>(dependencies.size());
        for (TypeDependencyInfo dependency : dependencies) {
            result.add(ArchitectureAssessmentService.buildTypeDependencyDto(architecture, dependency, findingIdsByDependency));
        }
        return result;
    }

    private static ArchitectureAssessmentDto.ArchitectureDependencyPolicyDto.ArchitectureTypeDependencyDto buildTypeDependencyDto(ArchitectureDefinition architecture, TypeDependencyInfo dependency, ListMap<Pair<String, String>, String> findingIdsByDependency) {
        List ids = (List)findingIdsByDependency.getCollection((Object)new Pair((Object)dependency.getFrom(), (Object)dependency.getTo()));
        String findingId = null;
        if (ids != null) {
            if (ids.size() != 1) {
                LOGGER.warn("Found {} findings for violation of dependency {} in architecture {}. Expected exactly one.", (Object)ids.size(), (Object)dependency, (Object)architecture.getName());
            }
            findingId = (String)ids.getFirst();
        }
        return new ArchitectureAssessmentDto.ArchitectureDependencyPolicyDto.ArchitectureTypeDependencyDto(dependency.getFrom(), dependency.getTo(), dependency.getFromPath(), dependency.getToPath(), findingId);
    }

    private static ArchitectureAssessmentDto.ArchitectureComponentDto buildArchitectureComponentDto(ArchitectureDefinition architecture, ArchitectureComponentInfo component, Map<String, List<TeamscaleIssueId>> matchedSpecItemIds, @Nullable Pattern typeSearchPattern) {
        ComponentNode componentNode = architecture.getComponentByName(component.name);
        List subComponents = CollectionUtils.map((Collection)component.getSubComponents(), subComponent -> ArchitectureAssessmentService.buildArchitectureComponentDto(architecture, subComponent, matchedSpecItemIds, typeSearchPattern));
        return new ArchitectureAssessmentDto.ArchitectureComponentDto(component.name, component.position, component.dimension, (Map<String, String>)component.getMatchedTypes(), component.stereotype, subComponents, ArchitectureAssessmentService.buildOverlaps(component), (List<String>)component.getRedundantIncludePatterns(), (List<Integer>)component.getNumberOfMatches(), componentNode.getSpecItemMapping(), matchedSpecItemIds.getOrDefault(component.name, Collections.emptyList()), ArchitectureAssessmentService.getTypeSearchResults(componentNode, component, typeSearchPattern), (List<CodeMapping>)componentNode.getCodeMappings(), componentNode.getDescription());
    }

    private static ArchitectureAssessmentDto.ArchitectureComponentDto.OverlapsDto buildOverlaps(ArchitectureComponentInfo component) {
        SetMap componentOverlaps = component.getComponentOverlaps();
        return new ArchitectureAssessmentDto.ArchitectureComponentDto.OverlapsDto(componentOverlaps.getRaw(), componentOverlaps.invert().getRaw());
    }

    private static PairList<String, String> getTypeSearchResults(ComponentNode componentNode, ArchitectureComponentInfo componentInfo, @Nullable Pattern typeSearchPattern) {
        PairList result = new PairList();
        if (typeSearchPattern == null) {
            return result;
        }
        UnmodifiableMap matchedTypes = componentInfo.getMatchedTypes();
        for (String matchedType : matchedTypes.keySet()) {
            if (!typeSearchPattern.matcher(matchedType).find()) continue;
            String pattern = ArchitectureAssessmentService.determineMatchingPattern(componentNode, matchedType);
            result.add((Object)matchedType, (Object)pattern);
        }
        return result;
    }

    @GET
    @Path(value="type-to-file-lookup")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get a lookup mapping from types to files.", description="Returns the lookup mapping from types to files. In the context of architecture assessments the lookup can be used to map from unmapped types of type based architectures to their respective code file location.", tags={"Architecture"})
    public Map<String, String> getTypeToFileLookup(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws ConQATException {
        HistoryAccessOption historyOption = this.determineHistoryOption(commit);
        TypeIndex typeIndex = this.openProjectIndex(TypeIndex.class, historyOption);
        HashMap<String, String> result = new HashMap<String, String>();
        typeIndex.getTypeFileLookupMap().forEach(entry -> result.put((String)entry.getKey(), (String)((List)entry.getValue()).getFirst()));
        return result;
    }

    @GET
    @PublicApi(since=ETeamscaleVersion.VERSION_5_7_0)
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get all architecture assessments", description="Returns available architecture assessments. All architectures in analyzed and in pending commits are returned including tags on the state of their analysis (added, modified, deleted). Returns an empty list if no assessments available.", tags={"Architecture"})
    public List<ArchitectureOverviewInfo> getAllArchitectureAssessments(@Parameter(description="ID of the project where architectures are defined.") @PathParam(value="project") PublicProjectId projectId, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        this.checkArchitectureAssessmentIndexExists(projectId);
        HistoryAccessOption historyOption = this.determineHistoryOption(commit);
        ArchitectureAssessmentIndex architectureAssessmentIndex = this.openProjectIndex(ArchitectureAssessmentIndex.class, historyOption);
        return this.getArchitectureInfos(architectureAssessmentIndex, historyOption);
    }

    @POST
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Assess architecture definition", description="Returns the architecture assessment of the given architecture definition.", tags={"Architecture"})
    public ArchitectureAssessmentDto postArchitectureAssessment(@Parameter(description="ID of the project where architecture should be defined.") @PathParam(value="project") PublicProjectId projectId, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="A type search query pattern") @QueryParam(value="type-search") Pattern typeSearch, @RequestBody(description="Architecture data", required=true) ArchitectureInfo architectureInfo) throws ConQATException {
        if (!this.projectIndexExists("dependencies") || !this.projectIndexExists("type-dependencies")) {
            throw new InternalServerErrorException("Dependency list and type dependency indices do not exist. Please check if architecture analysis is enabled for project " + String.valueOf(projectId) + ".");
        }
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        TypeDependencyIndex typeDependencyIndex = this.openProjectIndex(TypeDependencyIndex.class, historyAccessOption);
        TypeIndex typeIndex = this.openProjectIndex(TypeIndex.class, historyAccessOption);
        ArchitectureDefinition architecture = ArchitectureEditorUtils.writeArchitectureDefinition((ArchitectureInfo)architectureInfo);
        ListMap typeToFilesLookup = typeIndex.getTypeFileLookupMap();
        ArchitectureDefinition annotatedArchitecture = this.getArchitectureDefinition(architecture, (ListMap<String, String>)typeToFilesLookup, typeDependencyIndex, historyAccessOption);
        ITypeToFileLookup typeToFileLookup = ITypeToFileLookup.create((ArchitectureDefinition)architecture, (ListMap)typeToFilesLookup);
        Set projectLanguages = AnalysisProfileUtils.getConfiguredLanguages((MetaIndex)this.openProjectIndex(MetaIndex.class, null));
        ArchitectureAssessmentInfo architectureAssessment = ArchitectureAssessmentInfoUtils.convertToAssessmentInfo((ArchitectureDefinition)annotatedArchitecture, (ITypeToFileLookup)typeToFileLookup, (Set)projectLanguages);
        return this.buildArchitectureAssessmentDto(architecture, architectureAssessment, historyAccessOption, typeSearch);
    }

    private Map<String, List<TeamscaleIssueId>> findMatchedSpecItemIds(ArchitectureDefinition architecture, String branchName) throws StorageException {
        SpecItemMappingToIdsEvaluator evaluator = new SpecItemMappingToIdsEvaluator(this.openProjectIndex(SpecItemHistoryIndex.class, null), this.getGlobalStorageSystem(), (ProjectStorageSystem)this.getProjectStorageSystem(), this.getUser(), branchName);
        evaluator.evaluate(architecture);
        return evaluator.getComponentToSpecItemIds();
    }

    private static String determineMatchingPattern(ComponentNode component, String matchedType) {
        for (CodeMapping codeMapping : component.getCodeMappings()) {
            ECodeMappingType codeMappingType = codeMapping.getType();
            String pattern = codeMapping.getPattern();
            if (codeMappingType != ECodeMappingType.INCLUDE || !matchedType.matches(pattern)) continue;
            return pattern;
        }
        CCSMAssert.fail((String)("Obtained a matched type that is not matched by any include pattern: " + matchedType + "! This should never happen!"));
        return null;
    }

    private ArchitectureDefinition getArchitectureDefinition(ArchitectureDefinition architecture, ListMap<String, String> typeToFilesLookup, TypeDependencyIndex typeDependencyIndex, HistoryAccessOption historyAccessOption) throws ConQATException {
        SetMap scope = new SetMap();
        if (architecture.isFileBased()) {
            ArchitectureFileDependenciesIndex architectureFileDependenciesIndex = this.openProjectIndex(ArchitectureFileDependenciesIndex.class, historyAccessOption);
            scope = architectureFileDependenciesIndex.getDependencies();
        } else {
            ArchitectureTypeDependenciesIndex architectureTypeDependenciesIndex = this.openProjectIndex(ArchitectureTypeDependenciesIndex.class, historyAccessOption);
            Map dependencies1 = architectureTypeDependenciesIndex.getDependencyLocations();
            for (Map.Entry entry : dependencies1.entrySet()) {
                scope.addAll((Object)((String)entry.getKey()), (Collection)((ListMap)entry.getValue()).getKeys());
            }
        }
        TypeToComponentMapper mapper = new TypeToComponentMapper(architecture, this.getParallelTaskExecutor());
        TypeToComponentMapper.MappingResult mappingResult = mapper.map(ArchitectureAssessmentService.getTypes(architecture, typeDependencyIndex, typeToFilesLookup));
        TypeComponentMapping typeComponentMapping = new TypeComponentMapping(mappingResult);
        UnmodifiableList allDependencies = new ArchitectureAssessor(architecture, scope, typeComponentMapping).getAllDependencies();
        ArchitectureAnnotator annotator = new ArchitectureAnnotator(architecture, typeComponentMapping, (List)allDependencies);
        annotator.assess();
        annotator.annotateArchitectureWithResult();
        return architecture;
    }

    private static List<String> getTypes(ArchitectureDefinition architectureDefinition, TypeDependencyIndex typeDependencyIndex, ListMap<String, String> typeFileLookupMap) throws StorageException {
        ArrayList<String> types = new ArrayList<String>();
        if (architectureDefinition.isFileBased()) {
            PairList typeDependencies = typeDependencyIndex.getAllTypeDependencies();
            types.addAll(typeDependencies.extractFirstList());
            typeDependencies.extractSecondList().stream().flatMap(Collection::stream).flatMap(t -> t.getDependencies().stream()).filter(type -> !typeFileLookupMap.containsCollection(type)).forEach(types::add);
        } else {
            List dependencies = typeDependencyIndex.getAllTypeDependencies().extractSecondList();
            for (ArrayList deps : dependencies) {
                types.addAll(deps.stream().map(TypeDependencies::getType).toList());
                for (TypeDependencies depsv : deps) {
                    UnmodifiableSet dependencyLocations = depsv.getDependencies();
                    types.addAll((Collection<String>)dependencyLocations);
                }
            }
        }
        return types;
    }

    private void checkArchitectureAssessmentIndexExists(PublicProjectId projectId) {
        if (!this.projectIndexExists("architecture-assessment")) {
            throw new InternalServerErrorException("Architecture assessment index does not exist. Please check if architecture analysis is enabled for project " + String.valueOf(projectId) + ".");
        }
    }

    private List<ArchitectureOverviewInfo> getArchitectureInfos(ArchitectureAssessmentIndex architectureAssessmentIndex, HistoryAccessOption historyOption) throws StorageException {
        Map<String, ArchitectureUploadAnalysisStateIndex.EArchitectureUploadType> uploadsInProgress = ArchitectureAssessmentUtils.getUploadsInProgress((ProjectStorageSystem)this.getProjectStorageSystem(), historyOption);
        List existingArchitectures = architectureAssessmentIndex.getAllAssessmentUniformPaths();
        Map<String, ArchitectureOverviewInfo.EArchitecturePendingChangeType> pendingChangeTypes = ArchitectureAssessmentService.getPendingArchitectureChangeTypes(existingArchitectures, uploadsInProgress);
        BasicTokenElementIndex basicTokenElementIndex = this.openProjectIndex(BasicTokenElementIndex.class, historyOption);
        ArrayList<ArchitectureOverviewInfo> architectureInfos = new ArrayList<ArchitectureOverviewInfo>();
        ArrayList architecturePaths = new ArrayList(CollectionUtils.unionSet((Collection)existingArchitectures, (Collection[])new Collection[]{uploadsInProgress.keySet()}));
        List architectureElements = basicTokenElementIndex.getTokenElements(architecturePaths);
        for (int i = 0; i < architecturePaths.size(); ++i) {
            ArchitectureOverviewInfo.EArchitecturePendingChangeType changeType = pendingChangeTypes.get(architecturePaths.get(i));
            ArchitectureAssessmentInfo assessment = ArchitectureAssessmentUtils.getAssessmentInfo((String)architecturePaths.get(i), architectureAssessmentIndex);
            architectureInfos.add(ArchitectureAssessmentService.createArchitectureInfo((String)architecturePaths.get(i), (BasicTokenElementInfo)architectureElements.get(i), changeType, assessment));
        }
        return architectureInfos;
    }

    private static ArchitectureOverviewInfo createArchitectureInfo(String uniformPath, BasicTokenElementInfo architectureElement, ArchitectureOverviewInfo.EArchitecturePendingChangeType changeType, ArchitectureAssessmentInfo assessment) {
        int violations = 0;
        int orphans = 0;
        EFindingCreationType findingCreation = EFindingCreationType.NONE;
        long creationTimestamp = -1L;
        long modificationTimestamp = -1L;
        if (assessment != null) {
            orphans = assessment.orphanCount();
            violations = assessment.getViolationCount();
            findingCreation = assessment.getFindingCreation();
            ArchitectureCreationModificationInfo creationModificationInfo = assessment.getCreationModificationInfo();
            if (creationModificationInfo != null) {
                creationTimestamp = Optional.ofNullable(creationModificationInfo.getCreationDate()).orElse(creationTimestamp);
                modificationTimestamp = Optional.ofNullable(creationModificationInfo.getModificationDate()).orElse(modificationTimestamp);
            }
        }
        boolean isRepositoryArchitecture = changeType != ArchitectureOverviewInfo.EArchitecturePendingChangeType.DELETE && architectureElement != null;
        return new ArchitectureOverviewInfo(uniformPath, changeType, isRepositoryArchitecture, violations, orphans, findingCreation, creationTimestamp, modificationTimestamp);
    }

    private static Map<String, ArchitectureOverviewInfo.EArchitecturePendingChangeType> getPendingArchitectureChangeTypes(List<String> existingArchitectures, Map<String, ArchitectureUploadAnalysisStateIndex.EArchitectureUploadType> uploads) {
        HashMap<String, ArchitectureOverviewInfo.EArchitecturePendingChangeType> pendingChangeTypes = new HashMap<String, ArchitectureOverviewInfo.EArchitecturePendingChangeType>();
        HashSet addedPaths = new HashSet(CollectionUtils.filterAndMap(uploads.entrySet(), entry -> entry.getValue() == ArchitectureUploadAnalysisStateIndex.EArchitectureUploadType.ADD, Map.Entry::getKey));
        HashSet deletedPaths = new HashSet(CollectionUtils.filterAndMap(uploads.entrySet(), entry -> entry.getValue() == ArchitectureUploadAnalysisStateIndex.EArchitectureUploadType.DELETE, Map.Entry::getKey));
        for (Iterator deletedPath : deletedPaths) {
            pendingChangeTypes.put((String)((Object)deletedPath), ArchitectureOverviewInfo.EArchitecturePendingChangeType.DELETE);
        }
        HashSet modifiedPaths = CollectionUtils.intersectionSet(addedPaths, (Collection[])new Collection[]{existingArchitectures});
        addedPaths.removeAll(modifiedPaths);
        for (String addedPath : addedPaths) {
            pendingChangeTypes.put(addedPath, ArchitectureOverviewInfo.EArchitecturePendingChangeType.ADD);
        }
        for (String modifiedPath : modifiedPaths) {
            pendingChangeTypes.put(modifiedPath, ArchitectureOverviewInfo.EArchitecturePendingChangeType.MODIFY);
        }
        HashSet<String> unchangedArchitectures = new HashSet<String>(existingArchitectures);
        unchangedArchitectures.removeAll(addedPaths);
        unchangedArchitectures.removeAll(modifiedPaths);
        unchangedArchitectures.removeAll(deletedPaths);
        for (String unchangedArchitecture : unchangedArchitectures) {
            pendingChangeTypes.put(unchangedArchitecture, ArchitectureOverviewInfo.EArchitecturePendingChangeType.NONE);
        }
        return pendingChangeTypes;
    }
}

