/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.metrics.directory.MetricDirectoryIndex;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.service.audit.AuditUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class CodeFileInfo {
    private static final String UNIFORM_PATH_PROPERTY = "uniformPath";
    private static final String SOURCE_LINES_OF_CODE_PROPERTY = "sourceLinesOfCode";
    private static final String CLONE_COVERAGE_PROPERTY = "cloneCoverage";
    @JsonProperty(value="uniformPath")
    private final String uniformPath;
    @JsonProperty(value="sourceLinesOfCode")
    private final int sourceLinesOfCode;
    @JsonProperty(value="cloneCoverage")
    private final int cloneCoverage;

    @JsonCreator
    public CodeFileInfo(@JsonProperty(value="uniformPath") String uniformPath, @JsonProperty(value="sourceLinesOfCode") int sourceLinesOfCode, @JsonProperty(value="cloneCoverage") int cloneCoverage) {
        this.uniformPath = uniformPath;
        this.sourceLinesOfCode = sourceLinesOfCode;
        this.cloneCoverage = cloneCoverage;
    }

    public static CodeFileInfo create(UniformPath path, MetricDirectoryIndex metricDirectoryIndex, MetricDirectorySchema schema) throws StorageException {
        return CodeFileInfo.create(path.toString(), metricDirectoryIndex, schema);
    }

    public static CodeFileInfo create(String path, MetricDirectoryIndex metricDirectoryIndex, MetricDirectorySchema schema) throws StorageException {
        return new CodeFileInfo(path, AuditUtils.getFileMetricValueAsNumber(path, metricDirectoryIndex, schema, "Source Lines of Code").orElse(0), AuditUtils.getFileMetricValueAsNumber(path, metricDirectoryIndex, schema, "Clone Coverage").orElse(0));
    }

    public String getUniformPath() {
        return this.uniformPath;
    }

    public int getSourceLinesOfCode() {
        return this.sourceLinesOfCode;
    }

    public int getCloneCoverage() {
        return this.cloneCoverage;
    }
}

