/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.dependencies.DependencyListIndex;
import com.teamscale.index.dependencies.TypeDependencyIndex;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.metrics.architecture.MetricsToArchitectureMetricsMappingIndex;
import com.teamscale.service.architecture.dependency.ElementDependencyService;
import com.teamscale.service.audit.ProjectFilesService;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@Path(value="api/projects/{project}/audit/dependency-graph-extractor/{uniformPath: .*}")
public class DependencyGraphExtractorService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get the entire dependency graph of a system", description="Extracts the dependency graph of a project in the \"Trivial Graph Format\"", tags={"Audit"})
    public String getDependencyGraph(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @PathParam(value="uniformPath") UniformPath uniformPath) throws StorageException {
        HashMap<String, Integer> pathToNodeId = new HashMap<String, Integer>();
        StringBuilder graphBuilder = new StringBuilder();
        List<String> files = this.getAllUniformPaths(uniformPath, commit);
        DependencyGraphExtractorService.appendNodes(files, pathToNodeId, graphBuilder);
        graphBuilder.append("#").append(System.lineSeparator());
        this.appendEdges(files, commit, pathToNodeId, graphBuilder);
        return graphBuilder.toString();
    }

    private void appendEdges(List<String> files, UnresolvedCommitDescriptor commitDescriptor, Map<String, Integer> idMap, StringBuilder graphBuilder) throws StorageException {
        if (!(this.projectIndexExists("type-dependencies") && this.projectIndexExists("dependencies") && this.projectIndexExists("types"))) {
            return;
        }
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commitDescriptor);
        TypeDependencyIndex typeDependencyIndex = this.openProjectIndex(TypeDependencyIndex.class, historyAccessOption);
        DependencyListIndex pathDependencyIndex = this.openProjectIndex(DependencyListIndex.class, "dependencies", historyAccessOption);
        DependencyListIndex incomingDependencyIndex = this.openProjectIndex(DependencyListIndex.class, "inverse-dependencies", historyAccessOption);
        TypeIndex typeIndex = this.openProjectIndex(TypeIndex.class, historyAccessOption);
        for (String uniformPathFile : files) {
            List<ElementDependencyService.DependencyWithOccurrenceLocation> dependencyWithOccurrenceLocations = ElementDependencyService.getDependenciesWithOccurrenceLocation(UniformPathCompatibilityUtil.convert((String)uniformPathFile), false, typeDependencyIndex, pathDependencyIndex, typeIndex, incomingDependencyIndex);
            int sourceId = idMap.get(uniformPathFile);
            for (ElementDependencyService.DependencyWithOccurrenceLocation dependencyWithOccurrenceLocation : dependencyWithOccurrenceLocations) {
                Integer targetId = idMap.get(dependencyWithOccurrenceLocation.getDependencyUniformPath());
                if (targetId == null) continue;
                graphBuilder.append(sourceId).append(" ").append(targetId).append(System.lineSeparator());
            }
        }
    }

    private static void appendNodes(List<String> files, Map<String, Integer> idMap, StringBuilder graphBuilder) {
        int id = 0;
        for (String uniformPath : files) {
            if (idMap.containsKey(uniformPath)) continue;
            idMap.put(uniformPath, id);
            graphBuilder.append(id).append(" ").append(uniformPath).append(System.lineSeparator());
            ++id;
        }
    }

    private List<String> getAllUniformPaths(UniformPath uniformPath, UnresolvedCommitDescriptor commitDescriptor) throws StorageException {
        HistoryAccessOption historyOption = this.determineHistoryOption(commitDescriptor);
        MetricsToArchitectureMetricsMappingIndex metricsToArchitectureMetricsMappingIndex = this.openProjectIndex(MetricsToArchitectureMetricsMappingIndex.class, historyOption);
        TokenElementIndex contentIndex = this.openProjectIndex(TokenElementIndex.class, "content", historyOption);
        return ProjectFilesService.determineFilePaths(uniformPath, (FunctionWithException<String, List<String>, StorageException>)((FunctionWithException)arg_0 -> ((TokenElementIndex)contentIndex).getUniformPathsStartingWith(arg_0)), metricsToArchitectureMetricsMappingIndex);
    }
}

