/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit.file_summary;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.structure.LOCAnalyzer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class FileSummary {
    private final CounterSet<String> linesOfCodeMap;
    private final CounterSet<String> numberOfFiles;
    protected IncludeExcludeAntPatternSupport patternMatcher;

    public FileSummary(String path, List<String> includes, List<String> excludes) throws IOException {
        this.patternMatcher = new IncludeExcludeAntPatternSupport(false, includes, excludes);
        this.linesOfCodeMap = new CounterSet();
        this.numberOfFiles = new CounterSet();
        this.createFileSummary(path);
    }

    public PairList<String, FileSummaryInfoRecord> getLinesOfCodeAndNumberOfFiles() {
        PairList linesOfCodeAndNumberOfFiles = new PairList(this.linesOfCodeMap.getKeys().size());
        for (String fileType : this.linesOfCodeMap.getKeys()) {
            FileSummaryInfoRecord fileSummaryInfo = new FileSummaryInfoRecord(this.numberOfFiles.getValue((Object)fileType), this.linesOfCodeMap.getValue((Object)fileType));
            linesOfCodeAndNumberOfFiles.add((Object)fileType, (Object)fileSummaryInfo);
        }
        linesOfCodeAndNumberOfFiles.sort(Comparator.comparing(entry -> ((FileSummaryInfoRecord)entry.getSecond()).linesOfCode, Comparator.reverseOrder()));
        return linesOfCodeAndNumberOfFiles;
    }

    private void createFileSummary(String directoryName) throws IOException {
        Path directory = Paths.get(directoryName, new String[0]);
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new IOException("The path " + String.valueOf(directory) + " does not denote an existing directory!");
        }
        try (Stream<Path> paths = Files.walk(directory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> this.isIncludedInSummary(directory.relativize((Path)path)));){
            paths.forEach(path -> {
                try {
                    String fileType = FileSystemUtils.getFileExtension((File)path.toFile()).toLowerCase();
                    int loc = FileSummary.calculateLinesOfCode(path);
                    this.linesOfCodeMap.inc((Object)fileType, loc);
                    this.numberOfFiles.inc((Object)fileType);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private boolean isIncludedInSummary(Path relativePath) {
        return this.patternMatcher.isIncluded(relativePath.toString());
    }

    private static int calculateLinesOfCode(Path path) throws IOException {
        Charset charset = StandardCharsets.ISO_8859_1;
        try (BufferedReader reader = Files.newBufferedReader(path, charset);){
            int n = LOCAnalyzer.countLoc((BufferedReader)reader);
            return n;
        }
    }

    public record FileSummaryInfoRecord(@JsonProperty(value="numberOfFiles") int numberOfFiles, @JsonProperty(value="linesOfCode") int linesOfCode) {
    }
}

