/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.authenticate;

import com.teamscale.core.authenticate.teamscale.accesskeys.AccessKeyDTO;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.service.framework.authorization.RequiresUserPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;

public interface IAccessKeyServiceApi {
    @POST
    @Operation(summary="Generate Access Key", description="Generates a new access key.", tags={"Users"})
    @RequiresUserPermission(value={EBasicPermission.EDIT})
    public String createNewRandomAccessKey(@PathParam(value="user") String var1) throws StorageException;

    @DELETE
    @Operation(summary="Revoke Access Keys", description="Revokes the given access key of the user.", tags={"Users"})
    @RequiresUserPermission(value={EBasicPermission.EDIT})
    public void removeAccessKeys(@PathParam(value="user") String var1, @QueryParam(value="keys") Set<String> var2) throws StorageException;

    @GET
    @Operation(summary="List Access Keys Metadata", description="List the metadata of all access keys of the user", tags={"Users"})
    @RequiresUserPermission(value={EBasicPermission.EDIT})
    public List<AccessKeyDTO> getAccessKeysMetadata(@PathParam(value="user") String var1) throws StorageException;
}

