/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.authenticate;

import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationEntityNotFoundException;
import com.teamscale.core.authenticate.base.AuthenticationToolClientException;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.AuthenticationToolUtils;
import com.teamscale.core.authenticate.base.IAuthenticationToolProvider;
import com.teamscale.core.authenticate.base.IAutoCompletionStrategy;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/auth/import/users/auto-completion-suggestions")
public class ImportUsersAutoCompletionService
extends ApiBase {
    @GET
    @Operation(summary="Get auto-completion suggestions", description="Returns a list of suggested user names for auto-completion.", responses={@ApiResponse(responseCode="404", description="The given server could not be found")}, tags={"Users"})
    @Path(value="{input: .*}")
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_USERS})
    public List<String> getUserAutoCompletionSuggestions(@Parameter(description="The current input that should be auto-completed.", required=true) @PathParam(value="input") String toComplete, @Parameter(description="Maximum number of results to return.") @QueryParam(value="limit") @DefaultValue(value="200") int limit, @Parameter(description="The name of the remote server.", required=true) @QueryParam(value="server-name") String serverName, @Parameter(description="The type of the remote server (e.g. ldap or crowd).", required=true) @QueryParam(value="server-type") EAuthenticationTool serverType) throws StorageException, AuthenticationToolException {
        if (toComplete.isBlank()) {
            return Collections.emptyList();
        }
        try {
            IAuthenticationToolProvider toolProvider = AuthenticationToolUtils.getProvider((EAuthenticationTool)serverType, (GlobalStorageSystem)this.getGlobalStorageSystem(), (IMessageBroker)this.serviceInfo.getMessageBroker());
            IAutoCompletionStrategy userAutoCompletionStrategy = toolProvider.createUserAutoCompletionStrategy(serverName);
            return userAutoCompletionStrategy.getAutoCompletionsAndHandleErrors(toComplete, limit);
        }
        catch (AuthenticationEntityNotFoundException e) {
            throw new NotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (AuthenticationToolClientException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }
}

