/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.authenticate;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nimbusds.jose.JOSEException;
import com.teamscale.core.authenticate.AuthenticationManager;
import com.teamscale.core.authenticate.BearerAuthenticationHelper;
import com.teamscale.core.authenticate.SessionDuration;
import com.teamscale.core.authenticate.SessionIndex;
import com.teamscale.core.authenticate.teamscale.accesskeys.AccessKeyHandler;
import com.teamscale.core.authenticate.teamscale.accesskeys.EncryptedAccessKeyIndex;
import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserIndex;
import com.teamscale.core.user.UserUtils;
import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.text.ParseException;
import java.time.Duration;
import java.util.Arrays;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/auth/login")
public class LoginService
extends ApiBase {
    private static final Duration JWT_LOGIN_SESSION_DURATION = Duration.ofHours(1L);

    @POST
    @Operation(summary="Performs the login of a user.", description="Authenticates the user based on given credentials and returns a session cookie in case of success.")
    @RequiresNoLogin
    public Response performLogin(@RequestBody Credentials credentials) throws StorageException {
        User user = this.authenticateUserViaPassword(credentials);
        return this.serviceInfo.getAuthenticationRequestHandler().setSessionCookieHeader(user, Response.noContent(), this.serviceInfo.getRequestBaseUri(), this.openGlobalIndex(SessionIndex.class), credentials.stayLoggedIn).build();
    }

    @GET
    @Path(value="jwt")
    @Operation(summary="Performs the login using a short lived authentication token.", description="Authenticates the user based on a JSON web token.")
    @RequiresNoLogin
    @Hidden
    public Response performJwtLogin(@QueryParam(value="token") String token, @QueryParam(value="redirect") String redirectLocation) throws StorageException {
        try {
            User user = BearerAuthenticationHelper.ADMIN_LOGIN_INSTANCE.getUserFromJwt(token, BearerAuthenticationHelper.EJwtTokenType.LOGIN);
            this.preventTokenReuse(token);
            Response.ResponseBuilder response = Response.noContent();
            if (redirectLocation != null) {
                response = this.createRedirectResponseBuilder(redirectLocation);
            }
            return this.serviceInfo.getAuthenticationRequestHandler().setSessionCookieHeader(user, response, this.serviceInfo.getRequestBaseUri(), this.openGlobalIndex(SessionIndex.class), "BEARER", SessionDuration.withExplicitEndOfLife((Duration)JWT_LOGIN_SESSION_DURATION)).build();
        }
        catch (JOSEException | ParseException e) {
            throw new BadRequestException("Invalid token", e);
        }
    }

    private void preventTokenReuse(String token) {
        if (this.getIndexLayer().getMessageBroker().getAndIncrementCounterValue("jwt-login:" + XXHashUtils.xxhash64((String)token)) != 0L) {
            throw new BadRequestException("Reuse of tokens is not allowed!");
        }
    }

    private User authenticateUserViaPassword(Credentials credentials) throws StorageException {
        ServerOptionIndex optionIndex;
        UserIndex userIndex = this.openGlobalIndex(UserIndex.class);
        User user = (User)UserUtils.wipeAfterUse((char[])credentials.password, arg_0 -> LoginService.lambda$authenticateUserViaPassword$0(credentials, userIndex, optionIndex = this.openGlobalIndex(ServerOptionIndex.class), arg_0));
        if (user == null) {
            AuditLogs.failedUserAuthentication((String)credentials.username);
            throw new BadRequestException("Invalid username or password");
        }
        AuditLogs.userAuthentication((String)user.getUsername());
        return user;
    }

    @Path(value="access-key")
    @POST
    @Operation(summary="Returns the access key of a user.", description="Authenticates the user based on given credentials which can be either the password or an existing access key.  Generates and returns a new access key if a password has been provided.", tags={"Users"})
    @PublicApi(since=ETeamscaleVersion.VERSION_6_5_0)
    @RequiresNoLogin
    public String authenticateWithPasswordOrAccessKey(@RequestBody Credentials credentials) throws StorageException {
        User user = this.serviceInfo.getAuthenticationRequestHandler().authenticateViaEncryptedAccessToken(credentials.username, new String(credentials.password));
        if (user != null) {
            return Arrays.toString(credentials.password);
        }
        user = this.authenticateUserViaPassword(credentials);
        EncryptedAccessKeyIndex accessKeyIndex = this.openGlobalIndex(EncryptedAccessKeyIndex.class);
        return AccessKeyHandler.createAndStoreEncryptedAccessKey((String)user.getUsername(), (EncryptedAccessKeyIndex)accessKeyIndex);
    }

    private static /* synthetic */ User lambda$authenticateUserViaPassword$0(Credentials credentials, UserIndex userIndex, ServerOptionIndex optionIndex, byte[] passwordBytes) throws StorageException {
        return AuthenticationManager.getInstance().authenticate(credentials.username, passwordBytes, userIndex, optionIndex, true);
    }

    public static final class Credentials {
        @JsonProperty(value="username")
        public String username;
        @JsonProperty(value="password")
        @Schema(implementation=String.class)
        public char[] password;
        @JsonProperty(value="stayLoggedIn")
        public boolean stayLoggedIn;

        public Credentials() {
        }

        public Credentials(String username, String password, boolean stayLoggedIn) {
            this.username = username;
            this.password = password.toCharArray();
            this.stayLoggedIn = stayLoggedIn;
        }
    }
}

