/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.authenticate;

import com.atlassian.jwt.Jwt;
import com.atlassian.jwt.core.SimpleJwtParser;
import com.atlassian.jwt.exception.JwtParseException;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.ESsoAuthenticatorType;
import com.teamscale.core.authenticate.SessionIndex;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.AuthenticationToolUtils;
import com.teamscale.core.authenticate.openid.OpenIdAuthenticationOption;
import com.teamscale.core.authenticate.openid.OpenIdSessionIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserGroupUtils;
import com.teamscale.core.user.UserIndex;
import com.teamscale.core.user.UserUtils;
import com.teamscale.service.authenticate.IOpenIdRestClient;
import com.teamscale.service.authenticate.SsoAuthenticationServiceBase;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.RedirectionException;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Path(value="api/auth/openid")
public class OpenIdAuthenticationService
extends SsoAuthenticationServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Path(value="issuer-endpoints")
    @Operation(summary="Retrieves OpenID endpoints", description="Tries to retrieve all Teamscale-relevant endpoints from the issuer URL")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public IOpenIdRestClient.OpenIdEndpointInfo getOpenIdEndpoints(@QueryParam(value="issuer") String issuer) {
        try {
            return ((IOpenIdRestClient)Retrofit.builder((String)issuer).withInteractionLogger(LOGGER).withNoAuthentication().build().create(IOpenIdRestClient.class)).getConfiguration();
        }
        catch (ServiceCallException ex) {
            throw new ServerErrorException("OpenID configuration could not be retrieved from " + issuer + ". Please check that the URL is correct or define the endpoints manually.", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
    }

    @POST
    @Path(value="logout")
    @Operation(summary="Back channel logout for OpenID", description="Logs out user from Teamscale. This request is expected to be sent by the OpenID connector when the user logs out from another service.", operationId="openIdLogout")
    @RequiresNoLogin
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response logoutOpenId(@FormParam(value="logout_token") String logoutToken) {
        if (logoutToken == null) {
            return Response.ok().build();
        }
        try {
            Jwt jwt = new SimpleJwtParser().parse(logoutToken);
            LogoutToken userData = (LogoutToken)JsonUtils.deserializeFromJson((String)jwt.getJsonPayload(), LogoutToken.class);
            if (StringUtils.isEmpty((String)userData.sub) && StringUtils.isEmpty((String)userData.sid)) {
                throw new BadRequestException("Logout failed: logout token does neither contain a sub Claim nor a sid Claim.");
            }
            OpenIdSessionIndex openIdSessionIndex = this.openGlobalIndex(OpenIdSessionIndex.class);
            Optional invalidatedUser = Optional.empty();
            if (!StringUtils.isEmpty((String)userData.sub)) {
                invalidatedUser = openIdSessionIndex.getUserForSub(userData.sub);
            }
            if (invalidatedUser.isEmpty() && !StringUtils.isEmpty((String)userData.sid)) {
                invalidatedUser = openIdSessionIndex.getUserForSid(userData.sid);
            }
            if (invalidatedUser.isEmpty()) {
                return Response.ok().build();
            }
            SessionIndex sessionIndex = this.openGlobalIndex(SessionIndex.class);
            UserUtils.invalidateUserSession((String)((String)invalidatedUser.get()), (SessionIndex)sessionIndex, (IMessageBroker)this.serviceInfo.getMessageBroker());
            openIdSessionIndex.removeDataByUsername((String)invalidatedUser.get());
            return Response.ok().build();
        }
        catch (JwtParseException | JsonSerializationException | StorageException ex) {
            return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).entity((Object)("Logout failed: " + ex.getMessage())).build();
        }
    }

    @GET
    @Path(value="authenticate")
    @Operation(summary="Handles the redirection of the OpenID Connect authentication.", description="Redirects the user to the target that has been passed in the state parameter or dashboard.html if it does not exist. Uses the first OpenID connector for the authentication.")
    @RequiresNoLogin
    public Response authenticateWithoutServerName(@Parameter(description="The authentication code from OpenID.", required=true) @QueryParam(value="code") String code, @Parameter(description="The state that was passed to OpenID.") @QueryParam(value="state") String state) throws StorageException, AuthenticationToolException {
        return this.authenticate(null, code, state);
    }

    @GET
    @Path(value="authenticate/{serverName}")
    @Operation(summary="Handles the redirection of the OpenID Connect authentication.", description="Redirects the user to the target that has been passed in the state parameter or dashboard.html if it does not exist. Uses the OpenID connector with the specified name for the authentication.")
    @RequiresNoLogin
    public Response authenticate(@PathParam(value="serverName") String serverName, @Parameter(description="The authentication code from OpenID.", required=true) @QueryParam(value="code") String code, @Parameter(description="The state that was passed to OpenID.") @QueryParam(value="state") String state) throws StorageException, AuthenticationToolException {
        ServerOptionIndex optionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        Pair connectOptionWithName = AuthenticationToolUtils.determineConnectOption((String)ESsoAuthenticatorType.OPENID_CONNECT.getOptionId(), (String)serverName, (ServerOptionIndex)optionIndex, OpenIdAuthenticationOption.class);
        if (serverName == null) {
            serverName = (String)connectOptionWithName.getFirst();
        }
        OpenIdAuthenticationOption connectOption = (OpenIdAuthenticationOption)connectOptionWithName.getSecond();
        try {
            IOpenIdRestClient.TokenResponse tokenResponse = OpenIdAuthenticationService.requestTokens(code, connectOption);
            Optional<User> userOptional = this.getOrCreateAuthenticatedUser(tokenResponse, connectOption, this.serviceInfo.getMessageBroker(), serverName);
            if (userOptional.isEmpty()) {
                throw new RedirectionException("Failed to login via OpenID Connect. User does not exist as a Teamscale User.", 302, this.buildErrorURI("OpenIdNoSuchTeamscaleUser"));
            }
            return this.buildSsoResponse(userOptional.get(), state);
        }
        catch (ServiceCallException e) {
            throw new RedirectionException("Failed to login via OpenID Connect. Failed to communicate with the OpenID Connect service. Possible reasons are certification issues, incorrect client secret or that the service is not reachable.", 302, this.buildErrorURI("OpenIdServiceCallError"));
        }
        catch (JwtParseException | IOException | JsonSerializationException e) {
            throw new RedirectionException("Failed to login via OpenID Connect. Response from the OpenID Connect service could not be processed. Possible reasons are incompatible settings, please check our documentation for details.", 302, this.buildErrorURI("OpenIdSerializationError"));
        }
    }

    private static String getValueAsTextOrNullFromJson(JsonNode userData, String fieldName) {
        JsonNode node = userData.findValue(fieldName);
        if (node == null) {
            return null;
        }
        return node.asText();
    }

    private Optional<User> getOrCreateAuthenticatedUser(IOpenIdRestClient.TokenResponse tokenResponse, OpenIdAuthenticationOption connectOption, IMessageBroker messageBroker, String authenticatorName) throws StorageException, JwtParseException, JsonSerializationException, ServiceCallException {
        String sub;
        String idToken = tokenResponse.idToken;
        Jwt jwt = new SimpleJwtParser().parse(idToken);
        JsonNode userData = JsonUtils.deserializeFromJson((String)jwt.getJsonPayload());
        String userName = sub = OpenIdAuthenticationService.getValueAsTextOrNullFromJson(userData, "sub");
        if (!StringUtils.isEmpty((String)connectOption.getUsernameField())) {
            userName = OpenIdAuthenticationService.getValueAsTextOrNullFromJson(userData, connectOption.getUsernameField());
        }
        if (userName == null) {
            return Optional.empty();
        }
        UserIndex userIndex = this.openGlobalIndex(UserIndex.class);
        User teamscaleUser = userIndex.getUser(userName);
        if (teamscaleUser == null) {
            if (!connectOption.getAutoCreateUsers()) {
                return Optional.empty();
            }
            teamscaleUser = this.createNewUser(userName, userData, connectOption, tokenResponse.accessToken);
        }
        userIndex.setUser(teamscaleUser, messageBroker);
        String sid = OpenIdAuthenticationService.getValueAsTextOrNullFromJson(userData, "sid");
        OpenIdSessionIndex openIdSessionIndex = this.openGlobalIndex(OpenIdSessionIndex.class);
        openIdSessionIndex.storeLoginDataForUser(teamscaleUser.getUsername(), new OpenIdSessionIndex.LoginData(sub, sid, idToken, authenticatorName));
        return Optional.of(teamscaleUser);
    }

    private @NonNull User createNewUser(String userName, JsonNode userData, OpenIdAuthenticationOption connectOption, String accessToken) throws StorageException, ServiceCallException {
        String email = OpenIdAuthenticationService.getValueAsTextOrNullFromJson(userData, "email");
        String firstName = OpenIdAuthenticationService.getValueAsTextOrNullFromJson(userData, "given_name");
        String lastName = OpenIdAuthenticationService.getValueAsTextOrNullFromJson(userData, "family_name");
        String userinfoEndpoint = connectOption.getUserinfoEndpoint();
        if (!StringUtils.isEmpty((String)userinfoEndpoint)) {
            IOpenIdRestClient client = (IOpenIdRestClient)Retrofit.builder((String)connectOption.getIssuer()).withInteractionLogger(LOGGER).withBearerAuthentication(accessToken).create(IOpenIdRestClient.class);
            IOpenIdRestClient.UserInfo userInfo = client.getUserInfo(userinfoEndpoint);
            email = StringUtils.isEmptyOrElse((String)userInfo.email, (String)email);
            firstName = StringUtils.isEmptyOrElse((String)userInfo.givenName, (String)firstName);
            lastName = StringUtils.isEmptyOrElse((String)userInfo.familyName, (String)lastName);
        }
        User user = new User(userName, StringUtils.emptyIfNull((String)firstName), StringUtils.emptyIfNull((String)lastName), StringUtils.emptyIfNull((String)email), "OpenID Connect");
        UserGroupIndex groupIndex = this.openGlobalIndex(UserGroupIndex.class);
        List groups = StringUtils.splitToList((String)connectOption.getNewUserGroup(), (String)",");
        UserGroupUtils.addUserToGroups((User)user, (List)groups, (UserGroupIndex)groupIndex);
        return user;
    }

    private static IOpenIdRestClient.TokenResponse requestTokens(String authenticationCode, OpenIdAuthenticationOption applicationDescription) throws ServiceCallException, IOException {
        IOpenIdRestClient client = (IOpenIdRestClient)Retrofit.builder((String)applicationDescription.getIssuer()).withNoAuthentication().withInteractionLogger(LOGGER).build().create(IOpenIdRestClient.class);
        return client.validateAndObtainTokens(applicationDescription.getTokenEndpoint(), "authorization_code", applicationDescription.getRedirectUri(), applicationDescription.clientId, applicationDescription.clientSecret, authenticationCode);
    }

    private static class LogoutToken {
        @JsonProperty(value="sid")
        private @Nullable String sid;
        @JsonProperty(value="sub")
        private @Nullable String sub;

        private LogoutToken() {
        }
    }
}

