/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.authenticate.saml;

import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.ESsoAuthenticatorType;
import com.teamscale.core.authenticate.OAuthStateUtils;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.AuthenticationToolUtils;
import com.teamscale.core.authenticate.base.IAuthenticationToolProvider;
import com.teamscale.core.authenticate.base.ServerReference;
import com.teamscale.core.authenticate.index.OAuthStateIndex;
import com.teamscale.core.authenticate.saml.SamlAuthenticationOption;
import com.teamscale.core.authenticate.saml.SamlConfigurationCache;
import com.teamscale.core.authenticate.saml.SamlUser;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserGroupUtils;
import com.teamscale.core.user.UserIndex;
import com.teamscale.service.authenticate.SSORequestCookieHandler;
import com.teamscale.service.authenticate.SsoAuthenticationServiceBase;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Path(value="api/auth/saml/authenticate")
public class SamlAuthenticationService
extends SsoAuthenticationServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String SAML_RESPONSE_PARAMETER = "SAMLResponse";
    public static final String SAML_STATE_PARAMETER = "RelayState";

    @POST
    @Operation(summary="Handles the redirection of the SAML 2.0 Auth authentication.", description="Redirects the user to the target in their URL.")
    @RequiresNoLogin
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response authenticate(@FormParam(value="SAMLResponse") String samlResponse, @FormParam(value="RelayState") @Nullable String state, @Context ContainerRequestContext requestContext) throws StorageException {
        if (StringUtils.isEmpty((String)samlResponse)) {
            throw new BadRequestException("Invalid SAML response! Expecting parameter SAMLResponse in body!");
        }
        try {
            SamlUser samlUser = SamlConfigurationCache.getInstance().getUserFromResponse(samlResponse, this.getSamlOptions());
            Map<String, String> parameters = SamlAuthenticationService.parseRelayState(state);
            String csrfToken = parameters.getOrDefault("csrf", "");
            User user = SamlAuthenticationService.determineTeamscaleUser(samlUser, this.getGlobalStorageSystem(), this.getIndexLayer().getMessageBroker());
            String redirectUrl = parameters.get("url");
            return this.buildSsoResponse(user, redirectUrl);
        }
        catch (BadRequestException e) {
            LOGGER.debug("Invalid SAML response: " + samlResponse, (Throwable)e);
            throw e;
        }
    }

    public static Map<String, String> parseRelayState(@Nullable String relayState) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)relayState)) {
            return parameters;
        }
        for (String param : relayState.split("###")) {
            String[] keyValue = param.split("=", 2);
            if (keyValue.length != 2) continue;
            String key = keyValue[0];
            String value = keyValue[1];
            parameters.put(key, value);
        }
        return parameters;
    }

    private void validateCsrfToken(@Nullable String csrfToken, ContainerRequestContext requestContext) throws StorageException {
        try {
            Optional<String> currentSessionContext = SSORequestCookieHandler.getSSOCookieValue(requestContext);
            if (currentSessionContext.isEmpty()) {
                throw new IllegalArgumentException();
            }
            OAuthStateIndex stateIndex = this.openGlobalIndex(OAuthStateIndex.class);
            OAuthStateUtils.validateCsrfToken((String)csrfToken, (String)currentSessionContext.get(), (OAuthStateIndex)stateIndex);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Failed to login via SAML. " + e.getMessage(), (Throwable)e);
        }
    }

    @VisibleForTesting
    static @NonNull User determineTeamscaleUser(SamlUser samlUser, GlobalStorageSystem globalStorageSystem, IMessageBroker messageBroker) throws StorageException {
        String userName = samlUser.getTeamscaleUserName();
        UserIndex userIndex = (UserIndex)globalStorageSystem.openGlobalIndex(UserIndex.class);
        return (User)userIndex.computeWithUserUpdateLock(userName, () -> {
            User user = userIndex.getUser(userName);
            if (user == null) {
                user = SamlAuthenticationService.createTeamscaleUser(samlUser, userName, globalStorageSystem, messageBroker);
            }
            if (user == null) {
                throw new NotFoundException("User " + userName + " doesn't exist in Teamscale. Please contact your administrator.");
            }
            SamlAuthenticationService.synchronizeSamlGroups(samlUser, user, globalStorageSystem, messageBroker);
            SamlAuthenticationService.synchronizeAliases(samlUser, user, userIndex, messageBroker);
            return user;
        });
    }

    private static void synchronizeDelegateGroups(SamlUser samlUser, User user, GlobalStorageSystem globalStorageSystem, IMessageBroker messageBroker) throws StorageException {
        for (ServerReference delegateServer : samlUser.getSamlServer().getGroupDelegateServers()) {
            EAuthenticationTool authenticationTool = delegateServer.authenticationTool();
            String serverName = delegateServer.serverName();
            IAuthenticationToolProvider provider = AuthenticationToolUtils.getProvider((EAuthenticationTool)authenticationTool, (GlobalStorageSystem)globalStorageSystem, (IMessageBroker)messageBroker);
            try {
                provider.createSynchronizeUserGroupsStrategy(serverName).synchronizeUserGroups(user);
            }
            catch (AuthenticationToolException e) {
                LOGGER.warn("Could not synchronizer user from {}: {}", (Object)authenticationTool, (Object)serverName, (Object)e);
            }
        }
    }

    private static User createTeamscaleUser(SamlUser samlUser, String userName, GlobalStorageSystem globalStorageSystem, IMessageBroker messageBroker) throws BadRequestException, StorageException {
        SamlAuthenticationOption samlServer = samlUser.getSamlServer();
        if (!samlServer.autoCreateUsers) {
            return null;
        }
        String mail = samlUser.getFirstAttributeValue(samlServer.mailAttribute).orElse("");
        String firstName = samlUser.getFirstAttributeValue(samlServer.firstNameAttribute).orElse("");
        String lastName = samlUser.getFirstAttributeValue(samlServer.lastNameAttribute).orElse("");
        User user = new User(userName, firstName, lastName, mail, "SAML only");
        if (!StringUtils.isEmpty((String)samlServer.newUserGroup)) {
            UserGroupIndex groupIndex = (UserGroupIndex)globalStorageSystem.openGlobalIndex(UserGroupIndex.class);
            if (groupIndex.getUserGroup(samlServer.newUserGroup) == null) {
                throw new BadRequestException("Default user group " + samlServer.newUserGroup + " is not known to Teamscale. Please contact your administrator.");
            }
            UserGroupUtils.addUserToGroups((User)user, List.of(samlServer.newUserGroup), (UserGroupIndex)groupIndex);
        }
        SamlAuthenticationService.synchronizeDelegateGroups(samlUser, user, globalStorageSystem, messageBroker);
        ((UserIndex)globalStorageSystem.openGlobalIndex(UserIndex.class)).setUser(user, messageBroker);
        UserGroupUtils.invalidateCaches((IMessageBroker)messageBroker);
        return user;
    }

    private List<SamlAuthenticationOption> getSamlOptions() throws StorageException {
        ServerOptionIndex optionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        return CollectionUtils.map(ServerOptionRegistry.getServerMultiOptionAll((String)ESsoAuthenticatorType.SAML.getOptionId(), (ServerOptionIndex)optionIndex).values(), option -> (SamlAuthenticationOption)option);
    }

    private static void synchronizeSamlGroups(SamlUser samlUser, User user, GlobalStorageSystem globalStorageSystem, IMessageBroker messageBroker) throws StorageException {
        SamlAuthenticationOption samlServer = samlUser.getSamlServer();
        if (!samlServer.synchronizeGroups) {
            return;
        }
        List<String> groupNamesFromSaml = SamlAuthenticationService.determineGroupNamesFromSamlResponse(samlUser, samlServer);
        UserGroupIndex groupIndex = (UserGroupIndex)globalStorageSystem.openGlobalIndex(UserGroupIndex.class);
        List<String> groupNamesFromTeamscale = groupIndex.getGroupsForUser(user).stream().filter(group -> group.getAuthenticationTool() == EAuthenticationTool.SAML).map(UserGroup::getName).toList();
        ArrayList<String> groupsToRemove = new ArrayList<String>(CollectionUtils.differenceSet(groupNamesFromTeamscale, (Collection[])new Collection[]{groupNamesFromSaml}));
        ArrayList<String> groupsToAdd = new ArrayList<String>(CollectionUtils.differenceSet(groupNamesFromSaml, (Collection[])new Collection[]{groupNamesFromTeamscale}));
        if (!groupsToRemove.isEmpty() || !groupsToAdd.isEmpty()) {
            SamlAuthenticationService.updateTeamscaleGroups(user, groupIndex, groupsToRemove, groupsToAdd, samlServer.displayName, (UserIndex)globalStorageSystem.openGlobalIndex(UserIndex.class), messageBroker);
        }
    }

    private static List<String> determineGroupNamesFromSamlResponse(SamlUser samlUser, SamlAuthenticationOption samlServer) {
        List groupNamesFromSaml = samlUser.getAttributeValues(samlServer.groupsAttribute);
        if (!StringUtils.isEmpty((String)samlServer.groupsIncludePattern)) {
            Pattern includePattern = Pattern.compile(samlServer.groupsIncludePattern);
            groupNamesFromSaml = CollectionUtils.filter((Collection)groupNamesFromSaml, name -> includePattern.matcher((CharSequence)name).matches());
        }
        if (!StringUtils.isEmpty((String)samlServer.groupsExcludePattern)) {
            Pattern excludePattern = Pattern.compile(samlServer.groupsExcludePattern);
            groupNamesFromSaml = CollectionUtils.filter((Collection)groupNamesFromSaml, name -> !excludePattern.matcher((CharSequence)name).matches());
        }
        return groupNamesFromSaml;
    }

    private static void updateTeamscaleGroups(User user, UserGroupIndex groupIndex, List<String> groupsToRemove, List<String> groupsToAdd, String removeServer, UserIndex userIndex, IMessageBroker messageBroker) throws StorageException {
        if (!groupsToRemove.isEmpty()) {
            UserGroupUtils.removeUserFromGroups((User)user, groupsToRemove, (UserGroupIndex)groupIndex);
        }
        if (!groupsToAdd.isEmpty()) {
            groupsToAdd = SamlAuthenticationService.createMissingGroups(groupIndex, groupsToAdd, removeServer);
            UserGroupUtils.addUserToGroups((User)user, groupsToAdd, (UserGroupIndex)groupIndex);
        }
        userIndex.setUser(user, messageBroker);
        UserGroupUtils.invalidateCaches((IMessageBroker)messageBroker);
    }

    private static List<String> createMissingGroups(UserGroupIndex groupIndex, List<String> groupsToAdd, String remoteServer) throws StorageException {
        List groups = groupIndex.getUserGroups(groupsToAdd);
        ArrayList<String> filteredGroupNames = new ArrayList<String>();
        for (int i = 0; i < groups.size(); ++i) {
            if (groups.get(i) == null) {
                groupIndex.setGroup(new UserGroup(groupsToAdd.get(i), EAuthenticationTool.SAML, groupsToAdd.get(i), remoteServer));
                filteredGroupNames.add(groupsToAdd.get(i));
                continue;
            }
            if (((UserGroup)groups.get(i)).getAuthenticationTool() == EAuthenticationTool.SAML) {
                filteredGroupNames.add(groupsToAdd.get(i));
                continue;
            }
            LOGGER.warn("Ignoring passed group {} when synchronizing SAML groups, as this group originates not from SAML.", (Object)groupsToAdd.get(i));
        }
        return filteredGroupNames;
    }

    private static void synchronizeAliases(SamlUser samlUser, User user, UserIndex userIndex, IMessageBroker messageBroker) throws StorageException {
        SamlAuthenticationOption samlServer = samlUser.getSamlServer();
        if (StringUtils.isEmpty((String)samlServer.userAliasAttribute)) {
            return;
        }
        Optional optionalAlias = samlUser.getFirstAttributeValue(samlServer.userAliasAttribute);
        if (optionalAlias.isEmpty()) {
            return;
        }
        String alias = (String)optionalAlias.get();
        if (!user.getAliases().contains((Object)alias)) {
            user.addAliases(new String[]{alias});
            userIndex.setUser(user, messageBroker);
        }
    }
}

