/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.dataflow.debug;

import com.teamscale.core.findings.FindingsIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintAnalysisUtils;
import com.teamscale.index.tracking.index.TrackedFindingsIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.commons.findings.StatementPathElement;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/projects/{project}/dataflow/debug/taint-analysis-findings-export.csv")
public class TaintAnalysisFindingsExportService
extends ApiBase {
    private static final char CSV_SEPARATOR_CHAR = ';';

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get taint analysis findings", description="Exports findings of the taint analysis as a CSV table.", tags={"Debugging"})
    public Response getTaintFindingsCsv(@QueryParam(value="export-filtered-methods") @Parameter(description="Whether the findings for filtered methods should be exported (if true, normal taint findings will not be exported). Defaults to false.") boolean exportFilteredMethods, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws StorageException, IOException {
        HistoryAccessOption historyOption = this.determineHistoryOption(commit);
        FindingsIndex findingsIndex = this.openProjectIndex(FindingsIndex.class, historyOption);
        TrackedFindingsIndex trackedFindingsIndex = this.openProjectIndex(TrackedFindingsIndex.class, historyOption);
        try (StringWriter stringWriter = new StringWriter();){
            PrintWriter writer = new PrintWriter(stringWriter);
            try {
                if (exportFilteredMethods) {
                    TaintAnalysisFindingsExportService.writeFilteredMethodsFindingsTable(findingsIndex, trackedFindingsIndex, writer);
                } else {
                    TaintAnalysisFindingsExportService.writeTaintFindingsTable(findingsIndex, trackedFindingsIndex, writer);
                }
                String entity = stringWriter.toString();
                Response response = ResponseUtils.getFileDownloadResponse((Object)entity, (MediaType)MoreMediaTypes.TEXT_CSV_TYPE, (String)"taint-analysis-findings-export.csv");
                writer.close();
                return response;
            }
            catch (Throwable throwable) {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private static void writeFilteredMethodsFindingsTable(FindingsIndex findingsIndex, TrackedFindingsIndex trackedFindingsIndex, PrintWriter writer) throws StorageException {
        TaintAnalysisFindingsExportService.writeFilteredMethodFindingsHeader(writer);
        PairList findingsIndexEntries = findingsIndex.getFindingsInPartition("FailedMethodTaintGraphGenerationFindings");
        for (Pair findingsIndexEntry : findingsIndexEntries) {
            if (CollectionUtils.isNullOrEmpty((Collection)((Collection)findingsIndexEntry.getSecond()))) continue;
            for (IndexFinding finding : (List)findingsIndexEntry.getSecond()) {
                String findingId = TaintAnalysisFindingsExportService.getFindingId(finding, trackedFindingsIndex);
                TaintAnalysisFindingsExportService.writeFilteredMethodFinding((String)findingsIndexEntry.getFirst(), finding, findingId, writer);
            }
        }
    }

    private static void writeFilteredMethodFinding(String uniformPath, IndexFinding finding, String findingId, PrintWriter writer) {
        writer.append(uniformPath);
        writer.append(';');
        writer.append(TaintAnalysisFindingsExportService.escapeCsvField(finding.getLocationString()));
        writer.append(';');
        writer.append(TaintAnalysisFindingsExportService.escapeCsvField(finding.getTypeId()));
        writer.append(';');
        writer.append(TaintAnalysisFindingsExportService.escapeCsvField(finding.getMessage()));
        writer.append(';');
        writer.append(TaintAnalysisFindingsExportService.escapeCsvField(findingId));
        writer.append('\n');
    }

    private static void writeFilteredMethodFindingsHeader(PrintWriter writer) {
        writer.append("uniformPath");
        writer.append(';');
        writer.append("location");
        writer.append(';');
        writer.append("type");
        writer.append(';');
        writer.append("message");
        writer.append(';');
        writer.append("findingId");
        writer.append('\n');
    }

    private static void writeTaintFindingsTable(FindingsIndex findingsIndex, TrackedFindingsIndex trackedFindingsIndex, PrintWriter writer) throws StorageException {
        TaintAnalysisFindingsExportService.writeTaintAnalysisFindingsHeader(writer);
        PairList findingsIndexEntries = findingsIndex.getFindingsInPartition("datataint-findings");
        for (Pair findingsIndexEntry : findingsIndexEntries) {
            if (CollectionUtils.isNullOrEmpty((Collection)((Collection)findingsIndexEntry.getSecond()))) continue;
            for (IndexFinding finding : (List)findingsIndexEntry.getSecond()) {
                String findingId = TaintAnalysisFindingsExportService.getFindingId(finding, trackedFindingsIndex);
                TaintAnalysisFindingsExportService.writeTaintAnalysisFinding((String)findingsIndexEntry.getFirst(), finding, findingId, writer);
            }
        }
    }

    private static String getFindingId(IndexFinding finding, TrackedFindingsIndex trackedFindingsIndex) throws StorageException {
        List findingsInFile = trackedFindingsIndex.getFindings(finding.getLocation().getUniformPath());
        Optional<TrackedFinding> optionalTrackedFinding = findingsInFile.stream().filter(trackedFinding -> trackedFinding.getLocationString().equals(finding.getLocationString()) && trackedFinding.getMessage().equals(finding.getMessage())).findFirst();
        if (optionalTrackedFinding.isPresent()) {
            return optionalTrackedFinding.get().getId();
        }
        return "unknown";
    }

    private static void writeTaintAnalysisFinding(String uniformPath, IndexFinding finding, String findingId, PrintWriter writer) {
        StatementPathElement source = (StatementPathElement)finding.getStatementPath().get(0);
        StatementPathElement sink = (StatementPathElement)CollectionUtils.getAny((Iterable)TaintAnalysisUtils.getSinks((List)finding.getStatementPath()));
        String findingRuleName = finding.getProperties().getOrDefault("Rule name", "No Rule").toString();
        writer.append(TaintAnalysisFindingsExportService.escapeCsvField(uniformPath));
        writer.append(';');
        writer.append(TaintAnalysisFindingsExportService.escapeCsvField(source.getLocation().toLocationString()));
        writer.append(';');
        writer.append(TaintAnalysisFindingsExportService.escapeCsvField(source.getDescription()));
        writer.append(';');
        writer.append(TaintAnalysisFindingsExportService.escapeCsvField(sink.getLocation().toLocationString()));
        writer.append(';');
        writer.append(TaintAnalysisFindingsExportService.escapeCsvField(sink.getDescription()));
        writer.append(';');
        writer.append(TaintAnalysisFindingsExportService.escapeCsvField(finding.getCategoryName()));
        writer.append(';');
        writer.append(TaintAnalysisFindingsExportService.escapeCsvField(findingRuleName));
        writer.append(';');
        writer.append(TaintAnalysisFindingsExportService.escapeCsvField(finding.getMessage()));
        writer.append(';');
        writer.append(TaintAnalysisFindingsExportService.escapeCsvField(String.valueOf(finding.getStatementPath().size())));
        writer.append(';');
        writer.append(TaintAnalysisFindingsExportService.escapeCsvField(String.valueOf(finding.getStatementPath().stream().map(pathElement -> pathElement.getLocation().getUniformPath()).distinct().count())));
        writer.append(';');
        writer.append(TaintAnalysisFindingsExportService.escapeCsvField(findingId));
        writer.append('\n');
    }

    private static void writeTaintAnalysisFindingsHeader(PrintWriter writer) {
        writer.append("uniformPath");
        writer.append(';');
        writer.append("sourceLocation");
        writer.append(';');
        writer.append("sourceDescription");
        writer.append(';');
        writer.append("sinkLocation");
        writer.append(';');
        writer.append("sinkDescription");
        writer.append(';');
        writer.append("findingCategory");
        writer.append(';');
        writer.append("findingRule");
        writer.append(';');
        writer.append("message");
        writer.append(';');
        writer.append("pathNodes");
        writer.append(';');
        writer.append("involvedFiles");
        writer.append(';');
        writer.append("findingId");
        writer.append('\n');
    }

    private static String escapeCsvField(String field) {
        String newField = field.replace("\"", "\"\"\"");
        if (StringUtils.containsOneOf((String)newField, (String[])new String[]{String.valueOf(';'), "\n"})) {
            return "\"" + newField + "\"";
        }
        return newField;
    }
}

