/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.QualityIndicator;
import com.teamscale.core.analysis.configuration.model.AnalysisGroupDescriptor;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.configuration.AnalysisProfileVersionedIndex;
import com.teamscale.index.configuration.ExternalAnalysisGroup;
import com.teamscale.index.configuration.ExternalFindingsDescription;
import com.teamscale.index.configuration.service.AnalysisProfileUsageInfoWithProjects;
import com.teamscale.index.project.ExternalFindingsGroupDescriptionIndex;
import com.teamscale.index.upload.IExternalToolRule;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.project.ProjectReanalysisService;
import com.teamscale.service.project.analysis_profile.AnalysisProfileInfoService;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;

public abstract class FindingDescriptorCreationServiceBase<R extends IExternalToolRule>
extends ApiBase {
    private static final String CODE_ANOMALIES_QI_NAME = "Code Anomalies";
    protected static final String ANALYSIS_PROFILE_PARAMETER = "analysis-profile";
    public static final String ANALYSIS_PROFILE_PARAMETER_DESCRIPTION = "The name of the analysis profile to be updated. It cannot be null.";

    protected void doProcess(List<FormDataBodyPart> reports, String analysisProfileName) throws IOException, ProjectConfigurationException, ConQATException {
        String analysisGroupName;
        AnalysisProfileIndex analysisProfileIndex = this.openGlobalIndex(AnalysisProfileIndex.class);
        AnalysisProfile analysisProfile = analysisProfileIndex.getProfile(analysisProfileName);
        if (analysisProfile == null) {
            throw new NotFoundException("No such analysis profile: " + analysisProfileName);
        }
        List<R> rules = this.getRulesFromReports(reports);
        Set<String> addedRuleIds = this.registerFindingDescriptions(rules);
        ExternalAnalysisGroup externalAnalysisGroup = this.createExternalAnalysisGroupIfNotExists(addedRuleIds);
        ConfigurationTemplate template = AnalysisProfileUtils.getTemplateForProfile((AnalysisProfile)analysisProfile, (GlobalStorageSystem)this.getGlobalStorageSystem());
        AnalysisGroupDescriptor analysisGroupDescriptor = template.getAnalysisGroup(analysisGroupName = externalAnalysisGroup.getGroupName());
        if (analysisGroupDescriptor == null) {
            throw new BadRequestException("Unknown analysis group " + analysisGroupName);
        }
        FindingDescriptorCreationServiceBase.addRulesToAnalysisGroup(analysisProfile, analysisGroupName, analysisGroupDescriptor);
        AnalysisProfileVersionedIndex analysisProfileVersionedIndex = this.openGlobalIndex(AnalysisProfileVersionedIndex.class);
        AnalysisProfileUtils.addNewAnalysisProfileVersion((AnalysisProfileVersionedIndex)analysisProfileVersionedIndex, (AnalysisProfileIndex)analysisProfileIndex, (AnalysisProfile)analysisProfile, (String)"[System]", (String)"Profile updated by System", (GlobalStorageSystem)this.getGlobalStorageSystem());
        AnalysisProfileUtils.updateCurrentProfileSilently((AnalysisProfileVersionedIndex)analysisProfileVersionedIndex, (AnalysisProfileIndex)analysisProfileIndex, (AnalysisProfile)analysisProfile);
        this.updateReferencingProjects(analysisProfileName, analysisProfileIndex);
    }

    private List<R> getRulesFromReports(List<FormDataBodyPart> reports) throws ConQATException {
        HashMap rules = new HashMap();
        for (FormDataBodyPart report : reports) {
            this.parseReport(report.getValue(), rules);
        }
        return new ArrayList(rules.values());
    }

    protected abstract void parseReport(String var1, Map<String, R> var2) throws ConQATException;

    private Set<String> registerFindingDescriptions(List<R> rules) throws IOException, ConQATException {
        ExternalFindingsGroupDescriptionIndex index = this.openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class);
        HashMap<String, ExternalFindingsDescription> descriptions = new HashMap<String, ExternalFindingsDescription>();
        for (ExternalFindingsDescription externalFindingsDescription : index.getDescriptions(this.getTool())) {
            descriptions.put(externalFindingsDescription.getTypeId(), externalFindingsDescription);
        }
        HashSet<String> addedRuleIds = new HashSet<String>();
        for (IExternalToolRule rule : rules) {
            String ruleId = rule.getId();
            if (!descriptions.containsKey(ruleId)) {
                addedRuleIds.add(ruleId);
            }
            ExternalFindingsDescription description = new ExternalFindingsDescription(ruleId, rule.getShortDescription() + " (" + ruleId + ")", StringUtils.emptyIfNull((String)rule.getFullDescription()), rule.getFindingEnablement());
            descriptions.put(ruleId, description);
        }
        index.storeDescriptions(new ArrayList(descriptions.values()), this.getTool());
        return addedRuleIds;
    }

    private static void addRulesToAnalysisGroup(AnalysisProfile analysisProfile, String analysisGroupName, AnalysisGroupDescriptor analysisGroupDescriptor) {
        AnalysisGroup analysisGroup = FindingDescriptorCreationServiceBase.getOrCreateAnalysisGroup(analysisProfile, analysisGroupName);
        for (ConfigurationItemBase configItem : analysisGroupDescriptor.getConfigurationItems()) {
            if (!(configItem instanceof FindingDescriptor) || analysisGroup.getOptionValue(configItem.getName()) != null) continue;
            analysisGroup.setOptionValue(configItem.getName(), ((FindingDescriptor)configItem).getEnablement().toString());
        }
    }

    private static AnalysisGroup getOrCreateAnalysisGroup(AnalysisProfile analysisProfile, String analysisGroupName) {
        AnalysisGroup analysisGroup = AnalysisProfileUtils.getAnalysisGroup((AnalysisProfile)analysisProfile, (String)analysisGroupName);
        if (analysisGroup == null) {
            Optional<QualityIndicator> codeAnomaliesQualityIndicator = analysisProfile.getQualityIndicators().stream().filter(qualityIndicator -> qualityIndicator.getName().equals(CODE_ANOMALIES_QI_NAME)).findFirst();
            if (codeAnomaliesQualityIndicator.isEmpty()) {
                codeAnomaliesQualityIndicator = Optional.of(new QualityIndicator(CODE_ANOMALIES_QI_NAME));
                analysisProfile.addQualityIndicator(codeAnomaliesQualityIndicator.get());
            }
            analysisGroup = new AnalysisGroup(analysisGroupName);
            codeAnomaliesQualityIndicator.get().addGroup(analysisGroup);
        }
        return analysisGroup;
    }

    private void updateReferencingProjects(String analysisProfileName, AnalysisProfileIndex analysisProfileIndex) throws StorageException {
        ProjectIndex projectIndex = (ProjectIndex)this.getGlobalStorageSystem().openGlobalIndex(ProjectIndex.class);
        Map<String, AnalysisProfileUsageInfoWithProjects> projectsByProfile = AnalysisProfileInfoService.getProjectsByProfile(projectIndex, this.getPermissions(), false, this.serviceInfo.getIndexLayer());
        if (!projectsByProfile.containsKey(analysisProfileName)) {
            return;
        }
        for (PublicProjectId projectId : projectsByProfile.get(analysisProfileName).getCodeScopesByReferencedProjectIds().getKeys()) {
            this.getPermissions().checkProjectPermission((IProjectId)projectId, EProjectPermission.EDIT);
            ProjectReanalysisService.updateFindingsSchema((IProjectId)projectId, analysisProfileIndex, this.serviceInfo, analysisProfileName);
        }
    }

    private ExternalAnalysisGroup createExternalAnalysisGroupIfNotExists(Set<String> addedRuleIds) throws IOException, ConQATException {
        ExternalAnalysisGroup analysisGroup;
        ExternalFindingsGroupDescriptionIndex index = this.openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class);
        List allGroups = index.getGroups(this.getTool());
        if (allGroups.isEmpty()) {
            analysisGroup = new ExternalAnalysisGroup(this.getAnalysisGroupName(), StringUtils.concat(addedRuleIds, (String)"|"));
        } else {
            Object newMapping = ((ExternalAnalysisGroup)allGroups.get(0)).getMapping();
            if (!addedRuleIds.isEmpty()) {
                newMapping = (String)newMapping + "|" + StringUtils.concat(addedRuleIds, (String)"|");
            }
            analysisGroup = new ExternalAnalysisGroup(this.getAnalysisGroupName(), (String)newMapping);
            allGroups.clear();
        }
        allGroups.add(analysisGroup);
        index.storeGroups(allGroups, this.getTool());
        return analysisGroup;
    }

    protected abstract EAnalysisTool getTool();

    protected abstract String getAnalysisGroupName();
}

