/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.index.tracking.FindingIdentificationIndexCleanupTrigger;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/findings/debug/cleanup-finding-identifications")
public class DebugCleanupFindingIdentificationService
extends ApiBase {
    @POST
    @Operation(summary="Trigger finding identification cleanup", description="This service allows to schedule a job that performs a cleanup of the findings identification index, removing all references to findings that do not exist (anymore). ", tags={"Administration"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void scheduleCleanup(@QueryParam(value="dry-run") @Parameter(description="If this is provided, only a dry run is performed. In this case, only statistics are collected, without deleting any actual data.") boolean dryRun) throws StorageException {
        String dryRunParameter = null;
        if (dryRun) {
            dryRunParameter = "dry-run";
        }
        JobDescriptor job = new JobDescriptor(this.serviceInfo.getInternalId(), FindingIdentificationIndexCleanupTrigger.class, null, (Object)dryRunParameter, "Forced cleanup of finding identification index by user " + this.getUser().getUsername());
        ISchedulerCommunicator.getInstance().scheduleExternalJob(this.serviceInfo.getIndexLayer(), job);
    }
}

