/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request;

import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgressIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/merge-requests/analysis-progress-info")
public class MergeRequestAnalysisProgressInfoService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Retrieves the analysis progress of the given merge request in terms of commits left to be analyzed", tags={"Merge Requests"})
    public long getCommitsLeftToAnalyze(@Parameter(description="The name of the project.") @PathParam(value="project") PublicProjectId projectId, @Parameter(description="The source branch of the merge request.") @QueryParam(value="sourceBranch") String sourceBranch) throws StorageException {
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        ProjectInfo project = projectIndex.tryResolveProject((IProjectId)projectId).orElse(null);
        if (project == null || sourceBranch == null) {
            return 0L;
        }
        List analysisProgress = ((ProjectAnalysisProgressIndex)this.getIndexLayer().openNonHistorizedProjectIndex(ProjectAnalysisProgressIndex.class, project)).getProgress();
        return analysisProgress.stream().filter(revisionAnalysisProgress -> revisionAnalysisProgress.commit().getBranchName().equals(sourceBranch) && revisionAnalysisProgress.workOpen() > 0).count();
    }
}

