/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.merge_request.BranchPointNotFoundException;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestIndex;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.testgap.query.TgaRequestQueryOptions;
import com.teamscale.index.testimpact.TiaPartitionsQueryParams;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.testimpact.TestSuggestions;
import com.teamscale.service.testimpact.TgaBasedTestSuggestionsServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Optional;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/merge-requests/test-suggestions")
public class MergeRequestTestSuggestionsService
extends TgaBasedTestSuggestionsServiceBase {
    @GET
    @Operation(summary="Get merge request impacted tests", description="Retrieves the suggested tests for a merge request. You can either specify the merge request via its ID or by specifying the source and target branch head commits.", tags={"Merge Requests", "Test Intelligence"}, responses={@ApiResponse(responseCode="400", description="Could not find a common ancestor commit for source commit and target commit. Maybe the analyzed history is too short?")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @PublicApi(since=ETeamscaleVersion.VERSION_2025_6_0)
    public TestSuggestions getMergeRequestTestSuggestions(@Parameter(description="The ID of the merge request. The format is \"<repository-name>/<merge-request-id>\"") @QueryParam(value="merge-request-id") @Nullable MergeRequestIdentifier mergeRequestId, @Parameter(description="Source commit descriptor. This is usually the source branch name with suffixed with \":HEAD\" to refer to the the latest commit on that branch.") @QueryParam(value="source") UnresolvedCommitDescriptor unresolvedSourceCommit, @Parameter(description="Target commit descriptor. This is usually the branch name with suffixed with \":HEAD\" to refer to the the latest commit on that branch.") @QueryParam(value="target") UnresolvedCommitDescriptor unresolvedTargetCommit, @Parameter(description="Key of a precomputed merge-base info object.") @QueryParam(value="merge-base-cache-key") String cacheKey, @BeanParam TiaPartitionsQueryParams partitionInfo, @QueryParam(value="include-executed-tests") @Parameter(description="By default, tests that have at least passed once after all the methods that it covers were changed are omitted from the response. If set to true the already executed tests are also included.") boolean includeExecuted) throws StorageException, InterruptedException, RepositoryException, BranchPointNotFoundException {
        return this.getTestSuggestions(partitionInfo, null, this.getSourceAndTargetCommits(mergeRequestId, unresolvedSourceCommit, unresolvedTargetCommit), new TgaRequestQueryOptions(false, null, true, null, cacheKey, mergeRequestId), includeExecuted);
    }

    private @NonNull TimeIntervalBasedServiceQueryOptions getSourceAndTargetCommits(@Nullable MergeRequestIdentifier mergeRequestId, UnresolvedCommitDescriptor unresolvedSourceCommit, UnresolvedCommitDescriptor unresolvedTargetCommit) throws StorageException {
        if (mergeRequestId == null && (unresolvedSourceCommit.isDefaultAtHead() || unresolvedTargetCommit.isDefaultAtHead())) {
            throw new BadRequestException("Merge request ID or source/target branches are required!");
        }
        if (mergeRequestId != null) {
            MergeRequestIndex mergeRequestIndex = this.openProjectIndex(MergeRequestIndex.class, null);
            Optional mergeRequest = mergeRequestIndex.getMergeRequest(mergeRequestId);
            if (mergeRequest.isEmpty()) {
                throw new NotFoundException("No merge request with ID " + String.valueOf(mergeRequestId) + "!");
            }
            if (unresolvedSourceCommit.isDefaultAtHead()) {
                unresolvedSourceCommit = new UnresolvedCommitDescriptor(((MergeRequest)mergeRequest.get()).sourceBranch, Long.MAX_VALUE);
            }
            if (unresolvedTargetCommit.isDefaultAtHead()) {
                unresolvedTargetCommit = new UnresolvedCommitDescriptor(((MergeRequest)mergeRequest.get()).targetBranch, Long.MAX_VALUE);
            }
        }
        return new TimeIntervalBasedServiceQueryOptions(unresolvedTargetCommit, unresolvedSourceCommit);
    }
}

