/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request.metrics;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.index.findings.calculation.NonCodeBinarySizeElementFindingsRetriever;
import com.teamscale.index.metrics.assessment.context.PartitionUpdateType;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.service.base.TimeRange;
import com.teamscale.service.merge_request.metrics.DeltaEntry;
import com.teamscale.service.merge_request.metrics.EChangeType;
import com.teamscale.service.merge_request.metrics.EMetricTrendColor;
import com.teamscale.service.merge_request.metrics.MergeRequestSingleMetricDetailsBinarySizeUtils;
import com.teamscale.service.merge_request.metrics.MergeRequestSingleMetricDetailsUtils;
import com.teamscale.service.merge_request.metrics.SingleMetricDeltaParams;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

public class SingleMetricDeltaTableBuilder {
    private static final EMetricTrendColor BASE_COLOR = EMetricTrendColor.NEUTRAL_TEXT;
    private final UniformPath uniformPath;
    private final TimeRange range;
    private final IMetricRetrievalStrategy metricRetrievalStrategy;
    private final int metricIndex;
    private final BasicTokenElementIndex startBasicContentIndex;
    private final BasicTokenElementIndex endBasicContentIndex;
    private final boolean colorBlindModeEnabled;
    private final boolean hideRefactoredEntries;
    private final boolean filterUnchangedEntries;
    private final boolean showDeletedEntries;
    private final boolean calculateEntryBasedDeltaPercentage;
    private final PartitionUpdateType partitionUpdateType;

    public SingleMetricDeltaTableBuilder(SingleMetricDeltaParams params) {
        this.uniformPath = params.uniformPath();
        this.range = params.timeRange();
        this.metricRetrievalStrategy = params.metricRetrievalStrategy();
        this.metricIndex = params.metricIndex();
        this.startBasicContentIndex = params.startBasicContentIndex();
        this.endBasicContentIndex = params.endBasicContentIndex();
        this.colorBlindModeEnabled = params.isColorBlindModeEnabled();
        this.hideRefactoredEntries = params.isHideRefactoredEntries();
        this.filterUnchangedEntries = params.isFilteredUnchangedEntries();
        this.showDeletedEntries = params.isShowDeletedEntries();
        this.calculateEntryBasedDeltaPercentage = params.isCalculateEntryBasedDeltaPercentage();
        this.partitionUpdateType = params.partitionUpdateType();
    }

    public List<SingleMetricDeltaTableRowData> build() throws StorageException {
        if (this.partitionUpdateType == PartitionUpdateType.BRANCH_HEAD_OUTDATED || this.partitionUpdateType == PartitionUpdateType.NO_UPDATES) {
            return Collections.emptyList();
        }
        List<MetricDirectoryEntry> startEntries = this.getEntriesAt(this.range.start());
        if (this.partitionUpdateType == PartitionUpdateType.BASELINE_INCOMPLETE) {
            startEntries = new ArrayList<MetricDirectoryEntry>();
        }
        Map<String, NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent> startPathToContent = MergeRequestSingleMetricDetailsBinarySizeUtils.getNonCodeLinkContent(startEntries, this.startBasicContentIndex);
        List<MetricDirectoryEntry> endEntries = this.getEntriesAt(this.range.end());
        Map<String, NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent> endPathToContent = MergeRequestSingleMetricDetailsBinarySizeUtils.getNonCodeLinkContent(endEntries, this.endBasicContentIndex);
        SingleMetricDeltaTableBuilder.filterNonLeafEntries(startEntries, endEntries);
        return this.createRows(startEntries, endEntries, startPathToContent, endPathToContent, this.metricRetrievalStrategy.getMetricDirectorySchema());
    }

    private List<SingleMetricDeltaTableRowData> createRows(List<MetricDirectoryEntry> startEntries, List<MetricDirectoryEntry> endEntries, Map<String, NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent> startPathToContent, Map<String, NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent> endPathToContent, MetricDirectorySchema schema) {
        UnmodifiableMap<String, DeltaEntry> deltasByUniformPath = MergeRequestSingleMetricDetailsUtils.computeDeltasByUniformPath(startEntries, endEntries, startPathToContent, endPathToContent, this.metricIndex, schema, this.hideRefactoredEntries, this.filterUnchangedEntries, this.showDeletedEntries, this.partitionUpdateType);
        double maxDelta = deltasByUniformPath.values().stream().mapToDouble(DeltaEntry::delta).map(Math::abs).max().orElse(0.0);
        boolean isQualityNeutral = schema.getEntry(this.metricIndex).getProperties().contains(EMetricProperty.QUALITY_NEUTRAL);
        HashMap<String, SingleMetricDeltaTableRowData> rows = new HashMap<String, SingleMetricDeltaTableRowData>();
        this.createRowsForEntries(endEntries.stream(), deltasByUniformPath, schema, isQualityNeutral, rows, maxDelta);
        if (this.showDeletedEntries) {
            this.createRowsForEntries(startEntries.stream().filter(entry -> !rows.containsKey(entry.getUniformPath())).filter(entry -> entry.getValueWithoutNullAssert(this.metricIndex) != null), deltasByUniformPath, schema, isQualityNeutral, rows, maxDelta);
        }
        return new ArrayList<SingleMetricDeltaTableRowData>(rows.values());
    }

    private void createRowsForEntries(Stream<MetricDirectoryEntry> endEntriesStream, UnmodifiableMap<String, DeltaEntry> deltasByUniformPath, MetricDirectorySchema schema, boolean isQualityNeutral, Map<String, SingleMetricDeltaTableRowData> rows, double maxDelta) {
        endEntriesStream.map(endEntry -> this.createRow((MetricDirectoryEntry)endEntry, deltasByUniformPath, schema, isQualityNeutral, maxDelta)).filter(Objects::nonNull).forEach(row -> rows.put(row.path, (SingleMetricDeltaTableRowData)row));
    }

    private @Nullable SingleMetricDeltaTableRowData createRow(MetricDirectoryEntry entry, UnmodifiableMap<String, DeltaEntry> deltasByUniformPath, MetricDirectorySchema schema, boolean isQualityNeutral, double maxDelta) {
        double deltaChangePercentage;
        String path = entry.getUniformPath();
        DeltaEntry changeValue = (DeltaEntry)deltasByUniformPath.get((Object)path);
        if (changeValue == null) {
            return null;
        }
        Color trendColor = this.getTrendColor(changeValue, schema, isQualityNeutral);
        double absoluteValue = changeValue.change() != EChangeType.DELETE ? MergeRequestSingleMetricDetailsUtils.getAsDouble(entry, this.metricIndex, schema) : MergeRequestSingleMetricDetailsUtils.getDefaultValue(schema, this.metricIndex);
        if (MergeRequestSingleMetricDetailsUtils.isZero(changeValue.delta())) {
            deltaChangePercentage = 0.0;
        } else {
            double factor = this.calculateEntryBasedDeltaPercentage ? changeValue.startValue() : maxDelta;
            deltaChangePercentage = changeValue.delta() / factor;
        }
        return new SingleMetricDeltaTableRowData(path, changeValue.delta(), absoluteValue, trendColor, changeValue.change(), deltaChangePercentage);
    }

    private Color getTrendColor(DeltaEntry changeValue, MetricDirectorySchema schema, boolean isQualityNeutral) {
        if (isQualityNeutral) {
            return BASE_COLOR.getColor(this.colorBlindModeEnabled);
        }
        return Objects.requireNonNullElse(MergeRequestSingleMetricDetailsUtils.determineTrendColor(changeValue, schema, this.metricIndex), BASE_COLOR).getColor(this.colorBlindModeEnabled);
    }

    private List<MetricDirectoryEntry> getEntriesAt(CommitDescriptor range) throws StorageException {
        return this.metricRetrievalStrategy.getMetricDirectoryEntries(Collections.singletonList(this.uniformPath.toString()), HistoryAccessOption.readCommit((CommitDescriptor)range));
    }

    private static void filterNonLeafEntries(List<MetricDirectoryEntry> startEntries, List<MetricDirectoryEntry> endEntries) {
        Set<String> leafPaths = MergeRequestSingleMetricDetailsUtils.getLeafPaths(startEntries, endEntries);
        startEntries.removeIf(entry -> !leafPaths.contains(entry.getUniformPath()));
        endEntries.removeIf(entry -> !leafPaths.contains(entry.getUniformPath()));
    }

    public record SingleMetricDeltaTableRowData(@JsonProperty(value="path") String path, @JsonProperty(value="changeValue") double changeValue, @JsonProperty(value="absoluteValue") double absoluteValue, @JsonProperty(value="trendColor") Color trendColor, @JsonProperty(value="changeType") EChangeType changeType, @JsonProperty(value="deltaChangePercentage") double deltaChangePercentage) {
    }
}

