/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request.testcoverage;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestIndex;
import com.teamscale.index.merge_request.testcoverage.MergeRequestLineCoverageCalculator;
import com.teamscale.index.merge_request.testcoverage.TestCoverageDeltaInfo;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.service.commits.DirectedCommitDeltaServiceBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Optional;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CompactLines;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/merge-requests/{idWithRepository}/test-coverage")
public class MergeRequestTestCoverageService
extends DirectedCommitDeltaServiceBase {
    @GET
    @Operation(summary="Get merge request test coverage", description="Calculates how much lines of the new and changed lines are covered by tests.", tags={"Merge Requests", "Test Coverage"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public TestCoverageDeltaInfo getMergeRequestTestCoverage(@PathParam(value="idWithRepository") MergeRequestIdentifier identifier) throws StorageException {
        MergeRequest mergeRequest = this.getMergeRequest(identifier);
        CommitDescriptor sourceCommit = CommitDescriptor.latestOnBranch((String)mergeRequest.getSourceBranch());
        CommitDescriptor targetCommit = CommitDescriptor.latestOnBranch((String)mergeRequest.getTargetBranch());
        MergeBaseInfo mergeBaseInfo = this.getMergeBaseInfo(sourceCommit, targetCommit, null);
        return MergeRequestLineCoverageCalculator.getLineCoverageDelta((ProjectStorageSystem)this.serviceInfo.getProjectStorageSystem(), (CommitDescriptor)sourceCommit, (MergeBaseInfo)mergeBaseInfo, (MergeRequestIdentifier)identifier);
    }

    @GET
    @Path(value="changed-lines")
    @Operation(summary="Get merge request changed lines", description="Calculates the lines that have been changed in the merge request for the given file.", tags={"Merge Requests"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public CompactLines getMergeRequestChangedLines(@PathParam(value="idWithRepository") MergeRequestIdentifier identifier, @QueryParam(value="origin-path") @Parameter(required=true) UniformPath originPath, @QueryParam(value="path") @Parameter(required=true) UniformPath path) throws StorageException {
        MergeRequest mergeRequest = this.getMergeRequest(identifier);
        CommitDescriptor sourceCommit = CommitDescriptor.latestOnBranch((String)mergeRequest.getSourceBranch());
        CommitDescriptor targetCommit = CommitDescriptor.latestOnBranch((String)mergeRequest.getTargetBranch());
        MergeBaseInfo mergeBaseInfo = this.getMergeBaseInfo(sourceCommit, targetCommit, null);
        HistoryAccessOption baselineAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)mergeBaseInfo.getMergeBase());
        HistoryAccessOption sourceAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)sourceCommit);
        TokenElementIndex baselineElementIndex = this.openProjectIndex(TokenElementIndex.class, "content", baselineAccessOption);
        TokenElementIndex headElementIndex = this.openProjectIndex(TokenElementIndex.class, "content", sourceAccessOption);
        TokenElementInfo baselineTokenElement = baselineElementIndex.getTokenElement(originPath);
        TokenElementInfo headTokenElement = headElementIndex.getTokenElement(path);
        return MergeRequestLineCoverageCalculator.calculateNewAndChangedLines((TokenElementInfo)baselineTokenElement, (TokenElementInfo)headTokenElement);
    }

    private MergeRequest getMergeRequest(MergeRequestIdentifier identifier) throws StorageException {
        MergeRequestIndex mergeRequestIndex = this.openProjectIndex(MergeRequestIndex.class, null);
        Optional mergeRequest = mergeRequestIndex.getMergeRequest(identifier);
        if (mergeRequest.isEmpty()) {
            throw new NotFoundException("Merge request " + String.valueOf(identifier) + " not found");
        }
        return (MergeRequest)mergeRequest.get();
    }
}

