/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project.analysis_profile;

import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.CodeScope;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.QualityIndicator;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/configuration/analysis-groups")
public class AnalysisGroupService
extends ApiBase {
    @GET
    @Path(value="{groupName}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get analysis group", description="Returns a mapping from code scopes from the provided project to the analysis group from the analysis profile of the code scope identified by the group name.", responses={@ApiResponse(responseCode="404", description="Analysis group could not be found in any analysis profile.")}, tags={"Architecture"})
    public Map<String, @Nullable AnalysisGroup> getAnalysisGroupPerCodeScope(@Parameter(description="Name of the requested analysis group.") @PathParam(value="groupName") String groupName) throws StorageException {
        MetaIndex metaIndex = (MetaIndex)this.getProjectStorageSystem().openProjectIndex(MetaIndex.class, null);
        ProjectConfiguration projectConfiguration = (ProjectConfiguration)metaIndex.getValue(ProjectConfiguration.class);
        AnalysisProfileIndex analysisProfileIndex = this.openGlobalIndex(AnalysisProfileIndex.class);
        HashMap<String, AnalysisGroup> groupsByCodeScope = new HashMap<String, AnalysisGroup>();
        for (CodeScope codeScope : projectConfiguration.getCodeScopes()) {
            AnalysisProfile analysisProfile = analysisProfileIndex.getProfile(codeScope.getProfile());
            if (analysisProfile == null) {
                analysisProfile = codeScope.getEmbeddedProfile();
            }
            if (analysisProfile == null) {
                throw new InternalServerErrorException("Could not find all analysis profiles of the given project.");
            }
            groupsByCodeScope.put(codeScope.getName().name(), this.getGroupFromIndicators((List<QualityIndicator>)analysisProfile.getQualityIndicators(), groupName));
        }
        if (groupsByCodeScope.values().stream().allMatch(Objects::isNull)) {
            throw new NotFoundException("Requested group " + groupName + " could not be found in any analysis profile configured in the code scopes for the project.");
        }
        return groupsByCodeScope;
    }

    private @Nullable AnalysisGroup getGroupFromIndicators(List<QualityIndicator> qualityIndicators, String groupName) {
        for (QualityIndicator qualityIndicator : qualityIndicators) {
            for (AnalysisGroup group : qualityIndicator.getGroups()) {
                if (!groupName.equals(group.getName())) continue;
                return group;
            }
        }
        return null;
    }
}

