/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository.github;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.authenticate.github.GitHubAppUtils;
import com.teamscale.core.authenticate.github.GitHubApplicationDescription;
import com.teamscale.core.authenticate.github.client.GitHubAppClient;
import com.teamscale.core.authenticate.github.dto.InstallationRepositories;
import com.teamscale.core.authenticate.github.dto.InstallationRepository;
import com.teamscale.core.authenticate.github.index.GitHubInstallationIndex;
import com.teamscale.core.authenticate.github.index.LongKey;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.github.AppBasedGithubConnectorValidationUtils;
import com.teamscale.index.repository.git.github.GitHubAppBasedRepositoryAccessHelper;
import com.teamscale.index.repository.git.github.GitHubMergeRequestProvider;
import com.teamscale.index.repository.git.github.client.GitHubPullRequestClient;
import com.teamscale.index.repository.git.github.client.GitHubRepositoriesClient;
import com.teamscale.index.repository.git.github.data.GitHubBranch;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.github.GitHubServiceBase;
import com.teamscale.service.project.project_creation_wizard.ImportantBranchCalculator;
import com.teamscale.service.project.project_creation_wizard.ProjectLanguage;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/github")
public class GitHubRepositoriesService
extends GitHubServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Operation(summary="Gets GitHub repositories for all installed apps by github server URL", description="Get all GitHub repositories the instance can access.", tags={"Project"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public Map<String, List<InstallationRepository>> fetchGitHubProjects() throws StorageException, ServiceCallException, ExecutionException, InterruptedException {
        List<GitHubApplicationDescription> appDescriptions = this.getValidGitHubApplicationDescriptions();
        GitHubInstallationIndex gitHubInstallationIndex = this.openGlobalIndex(GitHubInstallationIndex.class);
        HashMap<String, List<InstallationRepository>> result = new HashMap<String, List<InstallationRepository>>();
        for (GitHubApplicationDescription appDescription : appDescriptions) {
            String appId = appDescription.appId;
            Set installationIdsForAppId = gitHubInstallationIndex.getInstallationIdsForAppId(Long.valueOf(Long.parseLong(appId)));
            GitHubAppClient githubAppClient = this.getGithubAppClient(appId);
            List installationRepositories = Collections.synchronizedList(new ArrayList());
            this.getParallelTaskExecutor().processInParallel((Collection)installationIdsForAppId, id -> installationRepositories.addAll(this.getRepositoriesUserHasAccessTo(appDescription, (Long)id, githubAppClient.getInstallationRepositories(id.longValue()), githubAppClient)));
            result.put(githubAppClient.getApplicationDescriptionServerUrl(), installationRepositories);
        }
        return result;
    }

    private Set<InstallationRepository> getRepositoriesUserHasAccessTo(GitHubApplicationDescription appDescription, Long id, InstallationRepositories installationRepositories, GitHubAppClient githubAppClient) throws ServiceCallException, StorageException {
        HashSet<InstallationRepository> repositories = new HashSet<InstallationRepository>();
        for (InstallationRepository installationRepository : installationRepositories.getRepositories()) {
            String accessToken = githubAppClient.getOrCreateInstallationToken(id.longValue());
            PlatformRepositoryIdentifier repositoryIdentifier = new PlatformRepositoryIdentifier(installationRepository.getOwner(), installationRepository.getName());
            if (appDescription.skipCollaboratorCheck) {
                repositories.add(installationRepository);
                continue;
            }
            try {
                AppBasedGithubConnectorValidationUtils.checkUserIsCollaborator((GitHubApplicationDescription)appDescription, (String)accessToken, (PlatformRepositoryIdentifier)repositoryIdentifier, (String)this.getUser().getUsername(), (Logger)LOGGER);
                repositories.add(installationRepository);
            }
            catch (ConnectorValidationException e) {
                LOGGER.debug("Skipping repository {} as user is not a collaborator.", (Object)repositoryIdentifier, (Object)e);
            }
        }
        return repositories;
    }

    @GET
    @Path(value="languages")
    @Operation(summary="Gets language of a repo.")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public List<ProjectLanguage> getGitHubLanguages(@QueryParam(value="repository") String repository) throws StorageException, ServiceCallException {
        GitHubAppBasedRepositoryAccessHelper<ServiceCallException> accessHelper = this.createAccessHelper(repository);
        GitHubRepositoriesClient client = accessHelper.createGitHubRepositoriesClient();
        Map languages = client.getRepositoryLanguages(PlatformRepositoryIdentifier.fromRepositoryName((String)repository));
        return ProjectLanguage.fromGitHub(languages);
    }

    @GET
    @Path(value="default-branch")
    @Operation(summary="Gets the default branch of a repo.")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public String getGitHubDefaultBranch(@QueryParam(value="repository") String repository) throws ServiceCallException, StorageException {
        GitHubAppBasedRepositoryAccessHelper<ServiceCallException> accessHelper = this.createAccessHelper(repository);
        GitHubRepositoriesClient client = accessHelper.createGitHubRepositoriesClient();
        return client.getRepository(PlatformRepositoryIdentifier.fromRepositoryName((String)repository)).defaultBranch();
    }

    @GET
    @Path(value="branches")
    @Operation(summary="Gets all branches of a repo.")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public List<String> getGitHubBranches(@QueryParam(value="repository") String repository) throws ServiceCallException, StorageException {
        GitHubAppBasedRepositoryAccessHelper<ServiceCallException> accessHelper = this.createAccessHelper(repository);
        GitHubRepositoriesClient client = accessHelper.createGitHubRepositoriesClient();
        return client.listAllBranches(PlatformRepositoryIdentifier.fromRepositoryName((String)repository)).stream().map(GitHubBranch::name).toList();
    }

    @GET
    @Path(value="important-branches")
    @Operation(summary="Gets the important branches of a repo.")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public List<String> getGitHubImportantBranches(@QueryParam(value="repository") String repository) throws ServiceCallException, StorageException {
        GitHubAppBasedRepositoryAccessHelper<ServiceCallException> accessHelper = this.createAccessHelper(repository);
        GitHubRepositoriesClient repoClient = accessHelper.createGitHubRepositoriesClient();
        GitHubPullRequestClient pullRequestClient = accessHelper.createGitHubPullRequestClient();
        PlatformRepositoryIdentifier repositoryIdentifier = PlatformRepositoryIdentifier.fromRepositoryName((String)repository);
        List branches = repoClient.listAllBranches(repositoryIdentifier);
        GitHubMergeRequestProvider provider = new GitHubMergeRequestProvider(repository, pullRequestClient, new IncludeExcludeRegexSupport(), "service");
        return GitHubRepositoriesService.getImportantBranchPatterns(provider, branches);
    }

    private static List<String> getImportantBranchPatterns(GitHubMergeRequestProvider provider, List<GitHubBranch> branches) throws ServiceCallException {
        List<String> mergeRequestTargets = provider.getAllSupportedOpenMergeRequests().stream().map(MergeRequest::getTargetBranch).toList();
        List<String> allBranches = branches.stream().map(GitHubBranch::name).toList();
        List<String> gitHubProtectedBranches = branches.stream().filter(GitHubBranch::isProtected).map(GitHubBranch::name).toList();
        ImportantBranchCalculator importantBranchCalculator = new ImportantBranchCalculator(mergeRequestTargets, allBranches, gitHubProtectedBranches);
        return importantBranchCalculator.getImportantBranchPattern();
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    private GitHubAppBasedRepositoryAccessHelper<ServiceCallException> createAccessHelper(String repository) throws StorageException, ServiceCallException {
        GitHubInstallationIndex gitHubInstallationIndex = this.openGlobalIndex(GitHubInstallationIndex.class);
        List installations = gitHubInstallationIndex.getAllRepositoryInstallations().filter((installation, repos) -> repos.contains(repository)).map((installation, repos) -> installation).stream().toList();
        Optional installation2 = installations.stream().findFirst();
        if (installation2.isEmpty()) {
            throw new ServiceCallException("No installation found for repository '%s'".formatted(repository));
        }
        Optional appId = gitHubInstallationIndex.getAppId(new LongKey(Long.parseLong((String)installation2.get())));
        if (appId.isEmpty()) {
            throw new ServiceCallException("No installation found for app '%s'".formatted(repository));
        }
        ServerOptionIndex optionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        List gitHubApplicationDescriptions = GitHubAppUtils.loadAllConfiguredApplications((ServerOptionIndex)optionIndex);
        GitHubApplicationDescription appDescription = gitHubApplicationDescriptions.stream().filter(desc -> desc.appId.equals(Long.toString((Long)appId.get()))).findFirst().orElseThrow(() -> new ServiceCallException("No installation found for app '%s'".formatted(repository)));
        return new GitHubAppBasedRepositoryAccessHelper(appDescription.serverUrl, repository, this.getGlobalStorageSystem(), ServiceCallException::new, LOGGER);
    }
}

