/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.index.findings.calculation.NonCodeBinarySizeElementFindingsRetriever;
import com.teamscale.index.resource.FormattedTokenElementInfo;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.index.resource.path_lookup.PathLookupOptions;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.resource.TokenElementServiceUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.index.shared.element_details.TokenElementDetailBase;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.region.LineBasedRegion;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

@Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
@Path(value="api/projects/{project}/content")
public class TokenElementService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Operation(summary="Get content for an element", description="Retrieves the content for an element.", tags={"Source Code"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public BasicTokenElementInfo getTokenElementInfo(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Uniform path to obtain the token element info for", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath) throws StorageException {
        return TokenElementServiceUtils.retrieveElement(uniformPath, (ProjectStorageSystem)this.getProjectStorageSystem(), this.determineHistoryOption(commit));
    }

    @GET
    @Path(value="details")
    @Operation(summary="Get details for a token element", description="Retrieves the details for a token element.", tags={"Source Code"}, responses={@ApiResponse(responseCode="204", description="The uniform path is not available.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public @Nullable List<TokenElementDetailBase> getTokenElementInfoDetails(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Uniform path to obtain the token element info for", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath) throws StorageException {
        TokenElementInfo tokenElementInfo = TokenElementServiceUtils.retrieveElement(uniformPath, (ProjectStorageSystem)this.getProjectStorageSystem(), this.determineHistoryOption(commit));
        if (tokenElementInfo == null) {
            return null;
        }
        return tokenElementInfo.getDetails();
    }

    @GET
    @Operation(summary="Get formatted content for an element", description="Retrieves the formatted content for an element.", tags={"Source Code"}, responses={@ApiResponse(responseCode="204", description="The uniform path is not available.")})
    @Path(value="formatted")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public @Nullable FormattedTokenElementInfo getFormattedTokenElementInfo(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Uniform path to obtain the token element info for", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath) throws StorageException {
        return TokenElementServiceUtils.getFormattedTokenElementInfo((ProjectStorageSystem)this.getProjectStorageSystem(), this.determineHistoryOption(commit), uniformPath);
    }

    @GET
    @Path(value="formatted/pre-commit/")
    @Operation(summary="Get the content for a pre-commit element", description="Retrieves the formatted content (i.e., incl. style information) for an element that is part of a pre-commit branch.", tags={"Source Code", "Pre-Commit"}, responses={@ApiResponse(responseCode="204", description="The uniform path is not available.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public @Nullable FormattedTokenElementInfo getPreCommitContent(@Parameter(description="Uniform path to obtain the token element info for", required=true) @QueryParam(value="uniform-path") UniformPath uniformPath, @Parameter(description="The commit id for which the pre-commit analysis has been triggered", required=true) @QueryParam(value="preCommitId") String preCommitId) throws StorageException {
        return TokenElementServiceUtils.getFormattedTokenElementInfo((ProjectStorageSystem)this.getProjectStorageSystem(), HistoryAccessOption.readHead((String)PreCommitUtils.createPrecommitBranchNameForCommitId((String)this.getUser().getUsername(), (String)preCommitId)), uniformPath);
    }

    @GET
    @Path(value="resolved")
    @Operation(summary="Resolves the element as a link", description="Tries to resolve the content of the token element as a link to another element. This currently only works for certain non-code metrics that have a json content attached with file and line properties.", tags={"Source Code"}, responses={@ApiResponse(responseCode="204", description="The uniform path could not be resolved to another uniform path.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public @Nullable ResourceLink tryResolveNonCodeLink(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Uniform path to obtain the link info for", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath) throws StorageException {
        if (!uniformPath.isNonCodePath()) {
            return null;
        }
        TokenElementInfo tokenElementInfo = TokenElementServiceUtils.retrieveElement(uniformPath, (ProjectStorageSystem)this.getProjectStorageSystem(), this.determineHistoryOption(commit));
        if (tokenElementInfo == null) {
            return null;
        }
        try {
            NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent link = (NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent)JsonUtils.deserializeFromJson((String)tokenElementInfo.getText(), NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent.class);
            PathLookupIndex pathLookupIndex = this.openProjectIndex(PathLookupIndex.class, this.determineHistoryOption(commit));
            Optional filePath = pathLookupIndex.lookupBestPath(link.file(), PathLookupOptions.defaults());
            if (filePath.isEmpty()) {
                LOGGER.warn("Did not find matching uniform path for {} referenced in {}!", (Object)link.file(), (Object)uniformPath);
                return null;
            }
            return new ResourceLink((String)filePath.get(), new LineBasedRegion(link.line(), link.line()));
        }
        catch (JsonSerializationException e) {
            LOGGER.debug("Failed to parse content of {}", (Object)uniformPath, (Object)e);
            return null;
        }
    }

    public record ResourceLink(@JsonProperty String uniformPath, @JsonProperty LineBasedRegion region) {
    }
}

