/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.testgap.MethodLastTestedIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/projects/{project}/test-gaps/partitions")
public class TgaPartitionsService
extends ApiBase {
    @GET
    @Operation(summary="Get TGA coverage partitions", description="Returns the available TGA coverage partitions of the project. This includes partitions from which coverage has been merged", tags={"Test Coverage"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<String> getTgaTestCoveragePartitions(@QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws StorageException {
        MethodLastTestedIndex methodLastTestedIndex = this.openProjectIndex(MethodLastTestedIndex.class, this.determineHistoryOption(commit));
        return CollectionUtils.sort((Collection)methodLastTestedIndex.getPartitions());
    }
}

