/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.tests;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.query.StoredQueryDescriptor;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.query.StoredQueriesServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/tests/queries")
public class StoredTestQueriesService
extends StoredQueriesServiceBase {
    public StoredTestQueriesService() {
        super(StoredQueryIndex.EStoredQueryType.TEST);
    }

    @GET
    @Operation(summary="Get stored test queries", description="Retrieves the list of available test query descriptors.", tags={"Tests", "Stored Queries"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<StoredQueryDescriptor> getStoredTestQueries() throws StorageException {
        return this.getAllQueries();
    }

    @POST
    @Operation(summary="Save test query", description="Creates a test query descriptor in the system.", tags={"Tests", "Stored Queries"})
    @RequiresProjectPermission(value={EProjectPermission.EDIT_TEST_QUERIES})
    public void saveTestQueryDescriptor(@RequestBody(required=true) StoredQueryDescriptor testMetricDescriptor) throws StorageException {
        this.storeQuery(testMetricDescriptor);
    }

    @DELETE
    @Path(value="{testQueryName}")
    @Operation(summary="Delete test query", description="Deletes a test query descriptor from the system.", tags={"Stored Queries", "Tests"}, responses={@ApiResponse(responseCode="404", description="Test query with the given name could not be found.")})
    @RequiresProjectPermission(value={EProjectPermission.EDIT_TEST_QUERIES})
    public void deleteTestQueryDescriptor(@Parameter(description="Name of the test query to delete") @PathParam(value="testQueryName") String testQueryName) throws StorageException {
        this.deleteQuery(testQueryName);
    }
}

