/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.treemap;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.service.treemap.CoverageMethodTreeMapNode;
import com.teamscale.service.treemap.FindingsResolvedMethodTreeMapNode;
import com.teamscale.service.treemap.MethodBasedTreeMapNodeBase;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.DefaultValue;
import java.awt.Color;
import java.util.IntSummaryStatistics;
import java.util.Objects;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.color.ColorUtils;

@Schema(oneOf={MatchedIssuesColorOption.class, FindingsSeverityColorOption.class, NumberOfFindingsColorOption.class, LineCoverageColorOption.class}, description="Describes how the treemap nodes should be colored.")
sealed interface IColorOption<NODE extends MethodBasedTreeMapNodeBase> {
    default public void updateStatistics(NODE node, TreemapContext context) {
    }

    public Color determineColor(NODE var1, TreemapContext var2);

    public String getColorMetricValue(NODE var1, TreemapContext var2);

    public static final class LineCoverageColorOption
    implements IColorOption<CoverageMethodTreeMapNode> {
        @JsonProperty(value="uncoveredColor")
        private Color uncoveredColor;
        @JsonProperty(value="fullyCoveredColor")
        private Color fullyCoveredColor;

        @Override
        public Color determineColor(CoverageMethodTreeMapNode coverageMethodTreeMapNode, TreemapContext context) {
            return ColorUtils.blend((double)coverageMethodTreeMapNode.getCoverage(), (Color)this.fullyCoveredColor, (Color)this.uncoveredColor);
        }

        @Override
        public String getColorMetricValue(CoverageMethodTreeMapNode node, TreemapContext context) {
            return String.valueOf(node.getCoverage());
        }
    }

    @Schema(description="Colors every node according to the worst severity of their assigned findings, 'green' if a node has no findings.")
    public record FindingsSeverityColorOption(@JsonProperty(value="colorBlindMode") @Schema(description="Whether color-blind specific colors should be used") @DefaultValue(value="false") boolean colorBlindModeEnabled) implements IColorOption<FindingsResolvedMethodTreeMapNode>
    {
        public static final String COLOR_BLIND_MODE_PARAMETER_NAME = "colorBlindMode";

        @Override
        public Color determineColor(FindingsResolvedMethodTreeMapNode node, TreemapContext context) {
            return FindingsSeverityColorOption.getDominantColor(node).getColor(this.colorBlindModeEnabled);
        }

        private static ETrafficLightColor getDominantColor(FindingsResolvedMethodTreeMapNode node) {
            return node.getFindings().stream().map(DetachedFinding::getAssessment).filter(Objects::nonNull).reduce(ETrafficLightColor.GREEN, ETrafficLightColor::getDominantColor);
        }

        @Override
        public String getColorMetricValue(FindingsResolvedMethodTreeMapNode node, TreemapContext context) {
            return String.valueOf(FindingsSeverityColorOption.getDominantColor(node).getDisplayText());
        }
    }

    @Schema(description="Colors every node depending on their number of findings with a gradient from `minFindingsColor` to `maxFindingsColor`")
    public static final class NumberOfFindingsColorOption
    implements IColorOption<FindingsResolvedMethodTreeMapNode> {
        public static final String MIN_FINDINGS_COLOR_PARAMETER_NAME = "minFindingsColor";
        public static final String COLOR_MIN_FINDINGS_VALUE_PARAMETER_NAME = "colorMinFindingsValue";
        public static final String MAX_FINDINGS_COLOR_PARAMETER_NAME = "maxFindingsColor";
        public static final String COLOR_MAX_FINDINGS_VALUE_PARAMETER_NAME = "colorMaxFindingsValue";
        @JsonProperty(value="minFindingsColor")
        private final Color minFindingsColor;
        @JsonProperty(value="colorMinFindingsValue")
        @Schema(description="The maximum number of findings a node can have to be colored in `minFindingsColor`. Use `-1` to automatically calculate the minimum number within the treemap.\n")
        private final int colorMinFindingsValue;
        @JsonProperty(value="maxFindingsColor")
        private final Color maxFindingsColor;
        @JsonProperty(value="colorMaxFindingsValue")
        @Schema(description="The minimum number of findings a node must have to be colored in `maxFindingsColor`. Use `-1` to automatically calculate the maximum number within the treemap.\n")
        private final int colorMaxFindingsValue;
        @JsonIgnore
        private final IntSummaryStatistics numberOfFindingsStatistics = new IntSummaryStatistics();

        @JsonCreator
        public NumberOfFindingsColorOption(@JsonProperty(value="minFindingsColor") Color minFindingsColor, @JsonProperty(value="colorMinFindingsValue") int colorMinFindingsValue, @JsonProperty(value="maxFindingsColor") Color maxFindingsColor, @JsonProperty(value="colorMaxFindingsValue") int colorMaxFindingsValue) {
            this.minFindingsColor = minFindingsColor;
            this.colorMinFindingsValue = colorMinFindingsValue;
            this.maxFindingsColor = maxFindingsColor;
            this.colorMaxFindingsValue = colorMaxFindingsValue;
        }

        @Override
        public void updateStatistics(FindingsResolvedMethodTreeMapNode node, TreemapContext context) {
            if (context.hasIssueQuery() && !context.hasMatchingIssueCount(node)) {
                return;
            }
            this.numberOfFindingsStatistics.accept(node.getNumberOfFindings());
        }

        @Override
        public Color determineColor(FindingsResolvedMethodTreeMapNode node, TreemapContext context) {
            return ColorUtils.computeColorGradient((int)node.getNumberOfFindings(), (int)this.colorMinFindingsValue, (Color)this.minFindingsColor, (int)this.colorMaxFindingsValue, (Color)this.maxFindingsColor, (IntSummaryStatistics)this.numberOfFindingsStatistics, (Color)this.minFindingsColor);
        }

        @Override
        public String getColorMetricValue(FindingsResolvedMethodTreeMapNode node, TreemapContext context) {
            return String.valueOf(node.getNumberOfFindings());
        }
    }

    @Schema(description="Colors every method/node depending on their number of matched issues with a gradient from `minReferencesColor` to `maxReferencesColor`.")
    public static final class MatchedIssuesColorOption
    implements IColorOption<FindingsResolvedMethodTreeMapNode> {
        public static final String MIN_REFERENCES_COLOR_PARAMETER_NAME = "minReferencesColor";
        public static final String COLOR_MIN_REFERENCES_VALUE_PARAMETER_NAME = "colorMinReferencesValue";
        public static final String MAX_REFERENCES_COLOR_PARAMETER_NAME = "maxReferencesColor";
        public static final String COLOR_MAX_REFERENCES_VALUE_PARAMETER_NAME = "colorMaxReferencesValue";
        @JsonProperty(value="minReferencesColor")
        private final Color minReferencesColor;
        @JsonProperty(value="colorMinReferencesValue")
        @Schema(description="The maximum number of issue references a node can have to be colored in `minReferencesColor`. Use `-1` to automatically calculate the minimum number within the treemap.\n")
        private final int colorMinReferencesValue;
        @JsonProperty(value="maxReferencesColor")
        private final Color maxReferencesColor;
        @JsonProperty(value="colorMaxReferencesValue")
        @Schema(description="The minimum number of issue references a node must have to be colored in `maxReferencesColor`. Use `-1` to automatically calculate the maximum number within the treemap.\n")
        private final int colorMaxReferencesValue;
        @JsonIgnore
        private final IntSummaryStatistics numberOfReferencesStatistics = new IntSummaryStatistics();

        @JsonCreator
        public MatchedIssuesColorOption(@JsonProperty(value="minReferencesColor") Color minReferencesColor, @JsonProperty(value="colorMinReferencesValue") int colorMinReferencesValue, @JsonProperty(value="maxReferencesColor") Color maxReferencesColor, @JsonProperty(value="colorMaxReferencesValue") int colorMaxReferencesValue) {
            this.minReferencesColor = minReferencesColor;
            this.colorMinReferencesValue = colorMinReferencesValue;
            this.maxReferencesColor = maxReferencesColor;
            this.colorMaxReferencesValue = colorMaxReferencesValue;
        }

        @Override
        public void updateStatistics(FindingsResolvedMethodTreeMapNode node, TreemapContext context) {
            if (context.hasMatchingIssueCount(node)) {
                this.numberOfReferencesStatistics.accept(node.getNumberOfMatchingIssues());
            }
        }

        @Override
        public Color determineColor(FindingsResolvedMethodTreeMapNode node, TreemapContext context) {
            if (!context.hasMatchingIssueCount(node)) {
                throw new IllegalArgumentException("Expected only nodes, which have enough matching issues, but got one without: " + node.getUniformPath() + "#" + node.getMethodName());
            }
            return ColorUtils.computeColorGradient((int)node.getNumberOfMatchingIssues(), (int)this.colorMinReferencesValue, (Color)this.minReferencesColor, (int)this.colorMaxReferencesValue, (Color)this.maxReferencesColor, (IntSummaryStatistics)this.numberOfReferencesStatistics, (Color)this.maxReferencesColor);
        }

        @Override
        public String getColorMetricValue(FindingsResolvedMethodTreeMapNode node, TreemapContext context) {
            return String.valueOf(node.getNumberOfMatchingIssues());
        }
    }

    public record TreemapContext(boolean hasIssueQuery, int minimumReferenceCount) {
        boolean hasMatchingIssueCount(MethodBasedTreeMapNodeBase node) {
            return node.getNumberOfMatchingIssues() >= this.minimumReferenceCount;
        }
    }
}

