/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.user.debug;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserIndex;
import com.teamscale.core.user.UserUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.permissions.PermissionFilterUtils;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/user/debug/invalid-users")
public class DebugInvalidUserService
extends ApiBase {
    @GET
    @Produces(value={"text/plain"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Get invalid users", description="Returns the inconsistent users.", tags={"Debugging"})
    public String getInvalidUsers() throws StorageException {
        UserIndex userIndex = this.openGlobalIndex(UserIndex.class);
        List<User> invalidUsers = this.getInvalidUsers(userIndex);
        if (invalidUsers.isEmpty()) {
            return "All good!";
        }
        StringBuilder result = new StringBuilder("Invalid users:\n\n");
        for (User invalidUser : invalidUsers) {
            result.append(DebugInvalidUserService.formatUser(invalidUser));
            result.append(" authenticator = ");
            result.append(invalidUser.getAuthenticator());
            result.append("\n");
        }
        return result.toString();
    }

    @POST
    @Produces(value={"text/plain"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Fix invalid users", description="Returns invalid users and deletes/fixes them. The authenticator for users without a valid authentication method will be set to 'DenyAll' and users with invalid characters in their username will be deleted (otherwise, nothing is changed).", tags={"Debugging"})
    public String fixInvalidUsers() throws StorageException {
        UserIndex userIndex = this.openGlobalIndex(UserIndex.class);
        List<User> invalidUsers = this.getInvalidUsers(userIndex);
        if (invalidUsers.isEmpty()) {
            return "No invalid users found. Nothing to do.";
        }
        StringBuilder result = new StringBuilder();
        for (User invalidUser : invalidUsers) {
            if (DebugInvalidUserService.hasInvalidUsername(invalidUser)) {
                UserUtils.deleteUser((User)invalidUser, (IndexLayer)this.getIndexLayer(), (IMessageBroker)this.serviceInfo.getMessageBroker());
                result.append("Deleted user with invalid username: ");
                result.append(DebugInvalidUserService.formatUser(invalidUser));
                result.append("\n");
                continue;
            }
            this.fixAuthenticator(invalidUser, userIndex);
            result.append("Fixed authenticator for user ");
            result.append(DebugInvalidUserService.formatUser(invalidUser));
            result.append("\n");
        }
        return result.toString();
    }

    private void fixAuthenticator(User invalidUser, UserIndex userIndex) throws StorageException {
        invalidUser.setAuthenticator("DenyAll");
        userIndex.setUser(invalidUser, this.serviceInfo.getMessageBroker());
    }

    private static String formatUser(User invalidUser) {
        return String.format("%s %s [%s]", invalidUser.getFirstName(), invalidUser.getLastName(), invalidUser.getUsername());
    }

    private List<User> getInvalidUsers(UserIndex userIndex) throws StorageException {
        return PermissionFilterUtils.getVisibleUsers(this.getPermissions(), userIndex).stream().filter(user -> !DebugInvalidUserService.hasAuthenticatorSet(user) || DebugInvalidUserService.hasInvalidUsername(user)).collect(Collectors.toList());
    }

    private static boolean hasAuthenticatorSet(User user) {
        return user.getAuthenticator() != null;
    }

    private static boolean hasInvalidUsername(User user) {
        return UserIndex.USERNAME_FORBIDDEN_CHARACTERS_REGEX.matcher(user.getUsername()).matches();
    }
}

