/*
 * Decompiled with CFR 0.152.
 */
package ru.bozaro.gitlfs.client.auth;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import ru.bozaro.gitlfs.client.auth.CachedAuthProvider;
import ru.bozaro.gitlfs.common.JsonHelper;
import ru.bozaro.gitlfs.common.data.Link;
import ru.bozaro.gitlfs.common.data.Operation;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u001b\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lru/bozaro/gitlfs/client/auth/ExternalAuthProvider;", "Lru/bozaro/gitlfs/client/auth/CachedAuthProvider;", "gitUrl", "", "(Ljava/lang/String;)V", "authority", "path", "(Ljava/lang/String;Ljava/lang/String;)V", "getAuthUncached", "Lru/bozaro/gitlfs/common/data/Link;", "operation", "Lru/bozaro/gitlfs/common/data/Operation;", "getCommand", "", "(Lru/bozaro/gitlfs/common/data/Operation;)[Ljava/lang/String;", "gitlfs-client"})
public class ExternalAuthProvider
extends CachedAuthProvider {
    @NotNull
    private final String authority;
    @NotNull
    private final String path;

    public ExternalAuthProvider(@NotNull String gitUrl) {
        Intrinsics.checkNotNullParameter((Object)gitUrl, (String)"gitUrl");
        int separator = StringsKt.indexOf$default((CharSequence)gitUrl, (char)':', (int)0, (boolean)false, (int)6, null);
        if (separator < 0) {
            throw new MalformedURLException("Can't find separator ':' in gitUrl: " + gitUrl);
        }
        String string = gitUrl.substring(0, separator);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        this.authority = string;
        String string2 = gitUrl.substring(separator + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        this.path = string2;
    }

    public ExternalAuthProvider(@NotNull String authority, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.authority = authority;
        this.path = path;
    }

    @Override
    @NotNull
    protected Link getAuthUncached(@NotNull Operation operation) throws IOException, InterruptedException {
        int read;
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        String[] stringArray = this.getCommand(operation);
        ProcessBuilder builder = new ProcessBuilder(new String[0]).command(Arrays.copyOf(stringArray, stringArray.length)).redirectError(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.PIPE);
        Process process = builder.start();
        process.getOutputStream().close();
        InputStream stdoutStream = process.getInputStream();
        ByteArrayOutputStream stdoutData = new ByteArrayOutputStream();
        byte[] buffer = new byte[65536];
        while ((read = stdoutStream.read(buffer)) > 0) {
            stdoutData.write(buffer, 0, read);
        }
        int exitValue = process.waitFor();
        if (exitValue != 0) {
            List<String> list = builder.command();
            Intrinsics.checkNotNullExpressionValue(list, (String)"builder.command()");
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String string = Arrays.toString(thisCollection$iv.toArray(new String[0]));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
            throw new IOException("Command returned with non-zero exit code " + exitValue + ": " + string);
        }
        Object object = JsonHelper.INSTANCE.getMapper().readValue(stdoutData.toByteArray(), Link.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"JsonHelper.mapper.readVa\u2026rray(), Link::class.java)");
        return (Link)object;
    }

    private final String[] getCommand(Operation operation) {
        String[] stringArray = new String[]{"ssh", this.authority, "-oBatchMode=yes", "-C", "git-lfs-authenticate", this.path, operation.toValue()};
        return stringArray;
    }
}

