/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableDecoratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleDecorator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorFixingDecorator;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FilterEntityTypeIterable
extends EntityIterableDecoratorBase {
    private final int entityTypeId;

    protected FilterEntityTypeIterable(@NotNull PersistentStoreTransaction txn, int entityTypeId, @NotNull EntityIterableBase source) {
        super(txn, source);
        this.entityTypeId = entityTypeId;
    }

    public static EntityIterableType getType() {
        return EntityIterableType.FILTER_ENTITY_TYPE;
    }

    @Override
    public int getEntityTypeId() {
        return this.entityTypeId;
    }

    @Override
    @NotNull
    public EntityIterator getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new EntityIteratorFixingDecorator(this, new NonDisposableEntityIterator(this){
            @NotNull
            private final EntityIteratorBase sourceIt;
            @Nullable
            private EntityId nextId;
            {
                this.sourceIt = (EntityIteratorBase)FilterEntityTypeIterable.this.source.iterator();
                this.nextId = PersistentEntityId.EMPTY_ID;
            }

            @Override
            protected boolean hasNextImpl() {
                if (this.nextId != PersistentEntityId.EMPTY_ID) {
                    return true;
                }
                while (this.sourceIt.hasNext()) {
                    this.nextId = this.sourceIt.nextId();
                    if (this.nextId != null && this.nextId.getTypeId() != FilterEntityTypeIterable.this.entityTypeId) continue;
                    return true;
                }
                return false;
            }

            @Override
            protected EntityId nextIdImpl() {
                EntityId result = this.nextId;
                this.nextId = PersistentEntityId.EMPTY_ID;
                return result;
            }
        });
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new EntityIterableHandleDecorator(this.getStore(), FilterEntityTypeIterable.getType(), this.source.getHandle()){

            @Override
            public void toString(@NotNull StringBuilder builder) {
                super.toString(builder);
                builder.append(FilterEntityTypeIterable.this.entityTypeId);
                builder.append('-');
                this.applyDecoratedToBuilder(builder);
            }

            @Override
            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                hash.apply(FilterEntityTypeIterable.this.entityTypeId);
                hash.applyDelimiter();
                super.hashCode(hash);
            }

            @Override
            public int getEntityTypeId() {
                return FilterEntityTypeIterable.this.entityTypeId;
            }
        };
    }

    @Override
    public boolean isSortedById() {
        return this.source.isSortedById();
    }

    @Override
    public boolean canBeCached() {
        return false;
    }

    static {
        FilterEntityTypeIterable.registerType(FilterEntityTypeIterable.getType(), (txn, store, parameters) -> new FilterEntityTypeIterable(txn, Integer.parseInt((String)parameters[0]), (EntityIterableBase)parameters[1]));
    }
}

