/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.ast;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.AstVisitor;
import com.sonar.sslr.api.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public final class AstWalker {
    private final Map<AstNodeType, AstVisitor[]> visitorsByNodeType = new IdentityHashMap<AstNodeType, AstVisitor[]>();
    private final List<AstVisitor> visitors = new ArrayList<AstVisitor>();
    private AstAndTokenVisitor[] astAndTokenVisitors = new AstAndTokenVisitor[0];
    private Token lastVisitedToken = null;

    public AstWalker(AstVisitor ... visitors) {
        this(Arrays.asList(visitors));
    }

    public AstWalker(List<? extends AstVisitor> visitors) {
        for (AstVisitor astVisitor : visitors) {
            this.addVisitor(astVisitor);
        }
    }

    public void addVisitor(AstVisitor visitor) {
        this.visitors.add(visitor);
        for (AstNodeType type : visitor.getAstNodeTypesToVisit()) {
            List<AstVisitor> visitorsByType = this.getAstVisitors(type);
            visitorsByType.add(visitor);
            this.putAstVisitors(type, visitorsByType);
        }
        if (visitor instanceof AstAndTokenVisitor) {
            ArrayList<AstAndTokenVisitor> tokenVisitorsList = new ArrayList<AstAndTokenVisitor>(Arrays.asList(this.astAndTokenVisitors));
            tokenVisitorsList.add((AstAndTokenVisitor)visitor);
            this.astAndTokenVisitors = tokenVisitorsList.toArray(new AstAndTokenVisitor[tokenVisitorsList.size()]);
        }
    }

    public void walkAndVisit(AstNode ast) {
        for (AstVisitor visitor : this.visitors) {
            visitor.visitFile(ast);
        }
        this.visit(ast);
        for (int i = this.visitors.size() - 1; i >= 0; --i) {
            this.visitors.get(i).leaveFile(ast);
        }
    }

    @Deprecated
    public void walkVisitAndListen(AstNode ast, Object output) {
        this.walkAndVisit(ast);
    }

    private void visit(AstNode ast) {
        AstVisitor[] nodeVisitors = this.getNodeVisitors(ast);
        AstWalker.visitNode(ast, nodeVisitors);
        this.visitToken(ast);
        this.visitChildren(ast);
        AstWalker.leaveNode(ast, nodeVisitors);
    }

    private static void leaveNode(AstNode ast, AstVisitor[] nodeVisitors) {
        for (int i = nodeVisitors.length - 1; i >= 0; --i) {
            nodeVisitors[i].leaveNode(ast);
        }
    }

    private void visitChildren(AstNode ast) {
        for (AstNode child : ast.getChildren()) {
            this.visit(child);
        }
    }

    private void visitToken(AstNode ast) {
        if (ast.getToken() != null && this.lastVisitedToken != ast.getToken()) {
            this.lastVisitedToken = ast.getToken();
            for (AstAndTokenVisitor astAndTokenVisitor : this.astAndTokenVisitors) {
                astAndTokenVisitor.visitToken(this.lastVisitedToken);
            }
        }
    }

    private static void visitNode(AstNode ast, AstVisitor[] nodeVisitors) {
        for (AstVisitor nodeVisitor : nodeVisitors) {
            nodeVisitor.visitNode(ast);
        }
    }

    private AstVisitor[] getNodeVisitors(AstNode ast) {
        AstVisitor[] nodeVisitors = this.visitorsByNodeType.get(ast.getType());
        if (nodeVisitors == null) {
            nodeVisitors = new AstVisitor[]{};
        }
        return nodeVisitors;
    }

    private void putAstVisitors(AstNodeType type, List<AstVisitor> visitors) {
        this.visitorsByNodeType.put(type, visitors.toArray(new AstVisitor[visitors.size()]));
    }

    private List<AstVisitor> getAstVisitors(AstNodeType type) {
        AstVisitor[] visitorsByType = this.visitorsByNodeType.get(type);
        return visitorsByType == null ? new ArrayList<AstVisitor>() : new ArrayList<AstVisitor>(Arrays.asList(visitorsByType));
    }
}

