/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.security;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.symbols.Symbols;
import org.sonar.php.tree.TreeUtils;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.ArrayInitializerTree;
import org.sonar.plugins.php.api.tree.expression.ArrayPairTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S5122")
public class CORSPolicyCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Make sure this permissive CORS policy is safe here.";

    @Override
    public void visitCompilationUnit(CompilationUnitTree compilationUnitTree) {
        if ("cors.php".equals(this.context().getPhpFile().filename())) {
            TreeUtils.firstDescendant((Tree)compilationUnitTree, ReturnStatementTree.class).ifPresent(this::checkCorsPhpFile);
        }
        super.visitCompilationUnit(compilationUnitTree);
    }

    @Override
    public void visitFunctionCall(FunctionCallTree functionCallTree) {
        FunctionCallHelper call = FunctionCallHelper.create(functionCallTree);
        if (call.isResponseConstuctorVulnerable() || call.isCoreHeaderVulnerable() || call.isSetOrHeaderVulnerable()) {
            this.context().newIssue(this, functionCallTree, MESSAGE);
        }
        super.visitFunctionCall(functionCallTree);
    }

    private void checkCorsPhpFile(ReturnStatementTree returnStatementTree) {
        ExpressionTree returnExpression = returnStatementTree.expression();
        if (returnExpression.is(Tree.Kind.ARRAY_INITIALIZER_BRACKET, Tree.Kind.ARRAY_INITIALIZER_FUNCTION)) {
            ((ArrayInitializerTree)returnExpression).arrayPairs().stream().filter(pair -> CORSPolicyCheck.isLiteralTreeEqualsTo(pair.key(), "allowed_origins") && CORSPolicyCheck.isSensitiveArray(pair.value())).forEach(pair -> this.context().newIssue(this, (Tree)pair, MESSAGE));
        }
    }

    private static boolean isSensitiveArray(ExpressionTree arrayValue) {
        return arrayValue.is(Tree.Kind.ARRAY_INITIALIZER_BRACKET, Tree.Kind.ARRAY_INITIALIZER_FUNCTION) && ((ArrayInitializerTree)arrayValue).arrayPairs().stream().anyMatch(pair -> CORSPolicyCheck.isLiteralTreeEqualsTo(pair.value(), "*"));
    }

    private static boolean isLiteralTreeEqualsTo(ExpressionTree tree, String expected) {
        return tree.is(Tree.Kind.REGULAR_STRING_LITERAL) && expected.equalsIgnoreCase(CheckUtils.trimQuotes(((LiteralTree)tree).value().replaceAll("\\s", "")));
    }

    private static class FunctionCallHelper {
        private static final QualifiedName HEADER_FUNCTION_NAME = QualifiedName.qualifiedName("header");
        private FunctionCallTree functionCallTree;
        private ExpressionTree callee;
        private static final Set<QualifiedName> RESPONSE_CLASSES = new HashSet<QualifiedName>(Arrays.asList(QualifiedName.qualifiedName("Symfony\\Component\\Httpfoundation\\Response"), QualifiedName.qualifiedName("Illuminate\\Http\\Response")));

        private FunctionCallHelper(FunctionCallTree functionCallTree) {
            this.functionCallTree = functionCallTree;
            this.callee = functionCallTree.callee();
        }

        static FunctionCallHelper create(FunctionCallTree functionCallTree) {
            return new FunctionCallHelper(functionCallTree);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isResponseConstuctorVulnerable() {
            if (!this.isResponseConstructorFunctionCall()) return false;
            if (!CheckUtils.argument(this.functionCallTree, "headers", 2).map(CallArgumentTree::value).map(CheckUtils::assignedValue).filter(ArrayInitializerTree.class::isInstance).map(ArrayInitializerTree.class::cast).filter(a -> a.arrayPairs().stream().anyMatch(FunctionCallHelper::isPairVulnerable)).isPresent()) return false;
            return true;
        }

        private static boolean isPairVulnerable(ArrayPairTree pair) {
            ExpressionTree key = pair.key();
            return key != null && CORSPolicyCheck.isLiteralTreeEqualsTo(key, "Access-Control-Allow-Origin") && CORSPolicyCheck.isLiteralTreeEqualsTo(pair.value(), "*");
        }

        private boolean isCoreHeaderVulnerable() {
            return this.isCoreHeaderFunctionCall() && this.retrieveArgumentAndVerifyItIsEqualsTo("header", 0, "Access-Control-Allow-Origin:*");
        }

        private boolean isSetOrHeaderVulnerable() {
            return this.isSetOrHeaderFunctionCall() && this.retrieveArgumentAndVerifyItIsEqualsTo("key", 0, "Access-Control-Allow-Origin") && this.retrieveArgumentAndVerifyItIsEqualsTo("values", 1, "*");
        }

        private boolean retrieveArgumentAndVerifyItIsEqualsTo(String name, int position, String expected) {
            Optional<CallArgumentTree> argumentTree = CheckUtils.argument(this.functionCallTree, name, position);
            return argumentTree.isPresent() && CORSPolicyCheck.isLiteralTreeEqualsTo(argumentTree.get().value(), expected);
        }

        private boolean isResponseConstructorFunctionCall() {
            return this.callee.is(Tree.Kind.NAMESPACE_NAME) && RESPONSE_CLASSES.contains(Symbols.getClass((NamespaceNameTree)this.callee).qualifiedName());
        }

        private boolean isCoreHeaderFunctionCall() {
            return Symbols.get(this.functionCallTree).qualifiedName().equals(HEADER_FUNCTION_NAME);
        }

        private boolean isSetOrHeaderFunctionCall() {
            return this.callee.is(Tree.Kind.OBJECT_MEMBER_ACCESS) && ("set".equals(CheckUtils.lowerCaseFunctionName(this.functionCallTree)) || HEADER_FUNCTION_NAME.simpleName().equals(CheckUtils.lowerCaseFunctionName(this.functionCallTree)));
        }
    }
}

