/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.statement;

import java.util.Iterator;
import java.util.List;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.php.utils.collections.IteratorUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.CaseClauseTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class CaseClauseTreeImpl
extends PHPTree
implements CaseClauseTree {
    private static final Tree.Kind KIND = Tree.Kind.CASE_CLAUSE;
    private final InternalSyntaxToken caseToken;
    private final ExpressionTree expression;
    private final InternalSyntaxToken caseSeparatorToken;
    private final List<StatementTree> statements;

    public CaseClauseTreeImpl(InternalSyntaxToken caseToken, ExpressionTree expression, InternalSyntaxToken caseSeparatorToken, List<StatementTree> statements) {
        this.caseToken = caseToken;
        this.expression = expression;
        this.caseSeparatorToken = caseSeparatorToken;
        this.statements = statements;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public Tree.Kind getKind() {
        return KIND;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return IteratorUtils.concat(IteratorUtils.iteratorOf(this.caseToken, this.expression, this.caseSeparatorToken), this.statements.iterator());
    }

    @Override
    public SyntaxToken caseToken() {
        return this.caseToken;
    }

    @Override
    public SyntaxToken caseSeparatorToken() {
        return this.caseSeparatorToken;
    }

    @Override
    public List<StatementTree> statements() {
        return this.statements;
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitCaseClause(this);
    }
}

